/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

@Named(value="enhanced")
@Component(role=LocalRepositoryManagerFactory.class, hint="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority = 10.0f;

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), session).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
    }

    public EnhancedLocalRepositoryManagerFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, EnhancedLocalRepositoryManager.class);
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public float getPriority() {
        return this.priority;
    }

    public EnhancedLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

