/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.text.MessageFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.debug.CommonLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.Messages;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchEventQueue;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class FBLaunchConfigurationDelegate
extends CommonLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IResource resource = LaunchConfigurationAttributes.getResource(configuration);
        if (resource instanceof IFile) {
            FBType type = (FBType)TypeLibraryManager.INSTANCE.getTypeEntryForFile((IFile)resource).getType();
            Event event = FBLaunchConfigurationAttributes.getEvent(configuration, type, this.getDefaultEvent(type));
            boolean repeatEvent = FBLaunchConfigurationAttributes.isRepeatEvent(configuration);
            boolean keepRunningWhenIdle = FBLaunchConfigurationAttributes.isKeepRunningWhenIdle(configuration);
            List<Variable<?>> defaultArguments = FBLaunchConfigurationDelegate.getDefaultArguments(type);
            List<Variable<?>> variables = LaunchConfigurationAttributes.getArguments(configuration, defaultArguments);
            FBDebugClockMode clockMode = FBLaunchConfigurationAttributes.getClockMode(configuration);
            Duration clockInterval = FBLaunchConfigurationAttributes.getClockInterval(configuration);
            Instant clockRealtimeOffset = FBLaunchConfigurationAttributes.getClockRealtimeOffset(configuration);
            Instant clockMonotonicOffset = FBLaunchConfigurationAttributes.getClockMonotonicOffset(configuration);
            FBLaunchEventQueue eventQueue = new FBLaunchEventQueue(event, repeatEvent, keepRunningWhenIdle);
            Clock realtimeClock = FBLaunchConfigurationDelegate.createClock(clockMode, clockRealtimeOffset, clockInterval, eventQueue);
            Clock monotonicClock = FBLaunchConfigurationDelegate.createClock(clockMode, clockMonotonicOffset, clockInterval, eventQueue);
            FBEvaluator<?> evaluator = this.createEvaluator(type, variables);
            evaluator.setEventQueue((FBEvaluatorEventQueue)eventQueue);
            this.launch((Evaluator)evaluator, realtimeClock, monotonicClock, configuration, mode, launch, resource, monitor);
        }
    }

    protected FBEvaluator<?> createEvaluator(FBType type, List<Variable<?>> variables) {
        return (FBEvaluator)EvaluatorFactory.createEvaluator((Object)type, type.eClass().getInstanceClass().asSubclass(FBType.class), (String)"sampling", null, variables, null);
    }

    public static Clock createClock(FBDebugClockMode mode, Instant offset, Duration interval, FBEvaluatorCountingEventQueue queue) {
        return switch (mode) {
            case FBDebugClockMode.SYSTEM -> null;
            case FBDebugClockMode.INTERVAL -> new AbstractEvaluator.IntervalClock(offset, interval, (ZoneId)ZoneOffset.UTC, queue, queue.getTotalInputCount().get());
            case FBDebugClockMode.FIXED -> Clock.fixed(offset, ZoneOffset.UTC);
            default -> throw new MatchException(null, null);
        };
    }

    public static List<Variable<?>> getDefaultArguments(FBType type) throws CoreException {
        try {
            return List.copyOf(new FBVariable("dummy", type).getChildren().toList());
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.FBLaunchConfigurationDelegate_InvalidDefaultArguments, type.getName()), (Throwable)e));
        }
    }

    protected Event getDefaultEvent(FBType type) {
        EList eventInputs = type.getInterfaceList().getEventInputs();
        if (!eventInputs.isEmpty()) {
            return (Event)eventInputs.get(0);
        }
        return null;
    }
}

