/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.List;
import java.util.SequencedSet;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;

public abstract class AbstractVirtualWatch
extends AbstractVariableWatch {
    private final SequencedSet<IVariableWatch> watches;

    protected AbstractVirtualWatch(Variable<?> variable, ITypedElement element, SequencedSet<IVariableWatch> watches, DeploymentDebugDevice debugTarget) {
        super(variable, element, debugTarget);
        this.watches = watches;
    }

    @Override
    public void addWatch() throws DebugException {
        for (IWatch iWatch : this.watches) {
            iWatch.addWatch();
        }
    }

    @Override
    public void removeWatch() throws DebugException {
        for (IWatch iWatch : this.watches) {
            iWatch.removeWatch();
        }
    }

    @Override
    public void updateValue(DeploymentDebugWatchData watchData) {
        if (this.watches.isEmpty()) {
            return;
        }
        for (IWatch iWatch : this.watches) {
            iWatch.updateValue(watchData);
            if (iWatch.isAlive()) continue;
            return;
        }
        this.updateValue(this.watches.stream().map(IVariableWatch::getInternalValue).toList());
    }

    protected abstract void updateValue(List<Value> var1);

    public SequencedSet<IVariableWatch> getWatches() {
        return this.watches;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

