/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;

public class PDFRoot
extends PDFObject {
    protected PDFPages rootPages;
    private PDFOutline _outline;
    private Collection _destinations;

    public PDFRoot(int number, PDFPages pages) {
        super(number);
        this.setRootPages(pages);
    }

    public void addPage(PDFPage page) {
        this.rootPages.addPage(page);
    }

    public Collection getDestinations() {
        if (this._destinations == null) {
            this._destinations = new ArrayList();
        }
        return this._destinations;
    }

    public PDFOutline getRootOutline() {
        return this._outline;
    }

    void setNumber(int number) {
        this.number = number;
    }

    public void setRootOutline(PDFOutline outline) {
        this._outline = outline;
    }

    public void setRootPages(PDFPages pages) {
        this.rootPages = pages;
    }

    public byte[] toPDF() throws IllegalStateException {
        StringBuffer p = new StringBuffer(String.valueOf(this.number) + " " + this.generation + " obj\n<< /Type /Catalog\n/Pages " + this.rootPages.referencePDF() + "\n");
        if (this._outline != null) {
            p.append(" /Outlines " + this._outline.referencePDF() + "\n");
            p.append(" /PageMode /UseOutlines\n");
        }
        if (this._destinations != null) {
            p.append(" /Names << /Dests << /Names [ ");
            Iterator i = this._destinations.iterator();
            while (i.hasNext()) {
                PDFDestination dest = (PDFDestination)i.next();
                p.append(dest.toPDF());
            }
            p.append(" ] >> >>\n");
        }
        p.append(" >>\nendobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return p.toString().getBytes();
        }
    }
}

