/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import com.sun.jimi.core.Jimi;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageConsumer;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.pdf.PDFColor;

public class JimiImage
extends AbstractFopImage {
    public JimiImage(URL href) throws FopImageException {
        super(href);
        try {
            Class<?> c = Class.forName("com.sun.jimi.core.Jimi");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FopImageException("Jimi image library not available");
        }
    }

    public JimiImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
        try {
            Class<?> c = Class.forName("com.sun.jimi.core.Jimi");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FopImageException("Jimi image library not available");
        }
    }

    protected void loadImage() throws FopImageException {
        int[] tmpMap;
        block13: {
            tmpMap = null;
            try {
                ImageProducer ip = Jimi.getImageProducer((InputStream)this.m_href.openStream(), (int)6);
                FopImageConsumer consumer = new FopImageConsumer(ip);
                ip.startProduction(consumer);
                while (!consumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.m_height = consumer.getHeight();
                this.m_width = consumer.getWidth();
                try {
                    tmpMap = consumer.getImage();
                }
                catch (Exception ex) {
                    throw new FopImageException("Image grabbing interrupted : " + ex.getMessage());
                }
                ColorModel cm = consumer.getColorModel();
                this.m_bitsPerPixel = 8;
                this.m_colorSpace = new ColorSpace(2);
                if (cm.hasAlpha()) {
                    int transparencyType = cm.getTransparency();
                    if (transparencyType == 1) {
                        this.m_isTransparent = false;
                        break block13;
                    }
                    if (transparencyType == 2) {
                        if (cm instanceof IndexColorModel) {
                            this.m_isTransparent = false;
                            byte[] alphas = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] reds = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] greens = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] blues = new byte[((IndexColorModel)cm).getMapSize()];
                            ((IndexColorModel)cm).getAlphas(alphas);
                            ((IndexColorModel)cm).getReds(reds);
                            ((IndexColorModel)cm).getGreens(greens);
                            ((IndexColorModel)cm).getBlues(blues);
                            int i = 0;
                            while (i < ((IndexColorModel)cm).getMapSize()) {
                                if ((alphas[i] & 0xFF) == 0) {
                                    this.m_isTransparent = true;
                                    this.m_transparentColor = new PDFColor(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                    break block13;
                                }
                                ++i;
                            }
                            break block13;
                        }
                        this.m_isTransparent = false;
                        break block13;
                    }
                    this.m_isTransparent = false;
                    break block13;
                }
                this.m_isTransparent = false;
            }
            catch (Exception ex) {
                throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + ex.getClass() + " - " + ex.getMessage());
            }
        }
        this.m_bitmapsSize = this.m_width * this.m_height * 3;
        this.m_bitmaps = new byte[this.m_bitmapsSize];
        int i = 0;
        while (i < this.m_height) {
            int j = 0;
            while (j < this.m_width) {
                int p = tmpMap[i * this.m_width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.m_bitmaps[3 * (i * this.m_width + j)] = (byte)(r & 0xFF);
                this.m_bitmaps[3 * (i * this.m_width + j) + 1] = (byte)(g & 0xFF);
                this.m_bitmaps[3 * (i * this.m_width + j) + 2] = (byte)(b & 0xFF);
                ++j;
            }
            ++i;
        }
    }
}

