/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.insd.edit.InsdConstants;
import org.apache.uima.pear.insd.edit.vars.VarVal;
import org.apache.uima.pear.insd.edit.vars.VarValList;
import org.apache.uima.pear.insd.edit.vars.VarValViewerHandler;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class INSDEnvironmentPage
extends WizardPage
implements InsdConstants {
    public Combo osCombo;
    public Combo jdkVersionCombo;
    public VarValViewerHandler viewer;
    public VarValList envVarList = new VarValList();
    InstallationDescriptor insd;
    IContainer currentContainer;
    Group gr;
    Group gr1;
    ArrayList MissingLibraries = new ArrayList();

    public INSDEnvironmentPage(IContainer currentContainer, InstallationDescriptor insd, Hashtable wizardData) {
        super("wizardPage");
        this.setTitle("UIMA - Installation Descriptor - Installation Environment");
        this.setDescription("Set the installation environment parameters and the system properties (e.g. classpath) for your component.\nNote: ClassPath entries must start with $main_root/");
        this.insd = insd;
        this.currentContainer = currentContainer;
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            FormLayout formLayout = new FormLayout();
            container.setLayout((Layout)formLayout);
            this.gr = new Group(container, 0);
            this.gr.setText("Environment Options");
            FormData data = new FormData();
            data.width = 450;
            data.left = new FormAttachment(0, 10);
            data.top = new FormAttachment(0, 10);
            this.gr.setLayoutData((Object)data);
            GridLayout grLayout = new GridLayout();
            grLayout.numColumns = 2;
            grLayout.verticalSpacing = 4;
            this.gr.setLayout((Layout)grLayout);
            this.osCombo = this.addCombo((Composite)this.gr, "Operating System:");
            this.jdkVersionCombo = this.addCombo((Composite)this.gr, "JDK level (Minimum):");
            this.gr1 = new Group(container, 0);
            this.gr1.setText("System Properties");
            data = new FormData();
            data.width = 450;
            data.height = 150;
            data.left = new FormAttachment(0, 10);
            data.top = new FormAttachment((Control)this.gr, 20, 1024);
            this.gr1.setLayoutData((Object)data);
            this.initialize();
            this.viewer = new VarValViewerHandler((Composite)this.gr1, VarVal.fieldNames, 3, this.envVarList);
            this.initializeCombos();
            this.dialogChanged();
            this.setControl((Control)container);
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The operation failed because the wizard's pages could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    private String getFirstItem(String tokens) {
        String firstItem = "";
        if (tokens != null && tokens.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(tokens, "\n");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken == null || nextToken.trim().length() <= 0) continue;
                firstItem = nextToken;
                break;
            }
        }
        return firstItem;
    }

    private Combo addCombo(Composite parent, String strLabel) {
        Label label = new Label(parent, 0);
        label.setText(strLabel);
        Combo text = new Combo(parent, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                INSDEnvironmentPage.this.dialogChanged();
            }
        });
        return text;
    }

    private void initializeCombos() {
        String selectedOS = "";
        String selectedJdkVersion = "";
        selectedOS = this.getFirstItem(this.insd.getOSSpecs().getProperty("NAME"));
        selectedJdkVersion = this.getFirstItem(this.insd.getToolkitsSpecs().getProperty("JDK_VERSION"));
        String[] items = new String[]{"Windows", "Linux", "Windows and Linux", "AIX"};
        String selectedItem = selectedOS;
        this.osCombo.setItems(items);
        if (selectedItem != null && !selectedItem.trim().equals("")) {
            this.osCombo.select(this.osCombo.indexOf(selectedItem));
        } else {
            this.osCombo.select(this.osCombo.indexOf(items[0]));
        }
        items = new String[]{"1.4.0"};
        selectedItem = selectedJdkVersion;
        this.jdkVersionCombo.setItems(items);
        if (selectedItem != null && !selectedItem.trim().equals("")) {
            this.jdkVersionCombo.select(this.jdkVersionCombo.indexOf(selectedItem));
        } else {
            this.jdkVersionCombo.select(this.jdkVersionCombo.indexOf(items[0]));
        }
    }

    private void initialize() {
        try {
            this.envVarList = new VarValList();
            Collection actionInfos = this.insd.getInstallationActions("set_env_variable");
            Iterator itr = actionInfos.iterator();
            String classPath = null;
            boolean classPathDefined = false;
            while (itr.hasNext()) {
                InstallationDescriptor.ActionInfo actionInfo = (InstallationDescriptor.ActionInfo)itr.next();
                String varName = actionInfo.params.getProperty("VAR_NAME");
                String varValue = null;
                if (varName != null && varName.trim().equalsIgnoreCase("classpath")) {
                    classPath = actionInfo.params.getProperty("VAR_VALUE");
                    varValue = this.getInitialClassPath(classPath);
                    classPathDefined = true;
                } else {
                    varValue = actionInfo.params.getProperty("VAR_VALUE");
                }
                if (varName == null || varName.trim().length() <= 0 || varValue == null) continue;
                VarVal varVal = new VarVal(varName, varValue);
                this.envVarList.addTableRow(varVal);
            }
            if (!classPathDefined) {
                VarVal varVal = new VarVal("CLASSPATH", this.getInitialClassPath(""));
                this.envVarList.addTableRow(varVal);
            }
        }
        catch (Throwable e) {
            PearException subEx = new PearException("Error. Cause: the environment page could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    private String getInitialClassPath(String classPath) {
        if (this.currentContainer.getType() != 4) {
            return classPath;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)this.currentContainer));
            if (javaProject != null && javaProject.exists()) {
                this.MissingLibraries = new ArrayList();
                IClasspathEntry[] classPathEntries = javaProject.getResolvedClasspath(true);
                ArrayList resultStringEntries = this.tokenizeClassPath(classPath);
                this.addToClassPath(classPathEntries, resultStringEntries);
                System.out.println("Output Location (normal): " + javaProject.getOutputLocation().toOSString());
                System.out.println("Output Location (relative): " + javaProject.getOutputLocation().makeRelative().toOSString());
                System.out.println("Output Location (absolute): " + javaProject.getOutputLocation().makeAbsolute().toOSString());
                Object outputLocation = "$main_root/" + javaProject.getOutputLocation().makeRelative().removeFirstSegments(1).toOSString();
                outputLocation = ((String)outputLocation).replace('\\', '/');
                outputLocation = ((String)outputLocation).trim();
                System.out.println("Output Location (to class path): " + (String)outputLocation);
                if (!this.contain(resultStringEntries, (String)outputLocation)) {
                    resultStringEntries.add(0, outputLocation);
                    System.out.println("\tadded Output Location to ClassPath: " + (String)outputLocation);
                }
                classPath = this.convertToString(resultStringEntries, ";");
                System.out.println("CLASSPATH: " + classPath);
                if (this.MissingLibraries != null && this.MissingLibraries.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    Iterator itr = this.MissingLibraries.iterator();
                    while (itr.hasNext()) {
                        sb.append("\n- ").append((String)itr.next());
                    }
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Missing class path entries", (String)("The following class path entries corresponds to resources not included in your project. Please make sure all the required class path resources (except JRE and UIMA jars) are included in this project and in the PEAR class path (in the environment page of the wizard):" + sb.toString()));
                }
            }
        }
        catch (Throwable e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Class Path Initialization", (String)"The class path could not be initialized properly. Please edit the class path variable in the environment page of the wizard.");
            e.printStackTrace();
        }
        return classPath;
    }

    private ArrayList tokenizeClassPath(String classPath) {
        ArrayList<String> resultStringEntries = new ArrayList<String>();
        if (classPath != null && !classPath.trim().equals("")) {
            String[] result = classPath.split("\\;");
            for (int i = 0; i < result.length; ++i) {
                resultStringEntries.add(result[i].trim());
            }
        }
        return resultStringEntries;
    }

    private ArrayList addToClassPath(IClasspathEntry[] classPathEntries, ArrayList resultStringEntries) {
        if (classPathEntries != null) {
            for (int i = 0; i < classPathEntries.length; ++i) {
                this.addToClassPath(classPathEntries[i], resultStringEntries);
            }
        }
        return resultStringEntries;
    }

    private String convertToString(ArrayList stringEntries, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator itr = stringEntries.iterator();
        while (itr.hasNext()) {
            sb.append((String)itr.next()).append(";");
        }
        return sb.toString();
    }

    private ArrayList addToClassPath(IClasspathEntry classPathEntry, ArrayList classPath) {
        int kind = classPathEntry.getEntryKind();
        IPath path = classPathEntry.getPath();
        System.out.println("ClassEntry:");
        System.out.println("\tOriginal : " + path.toOSString());
        System.out.println("\tRelative : " + path.makeRelative().toOSString());
        System.out.println("\tAbsolute : " + path.makeAbsolute().toOSString());
        switch (kind) {
            case 1: {
                path = classPathEntry.getPath();
                boolean inProject = this.currentContainer.getFullPath().makeAbsolute().isPrefixOf(path.makeAbsolute());
                System.out.println("\tProject (full absolute): " + this.currentContainer.getFullPath().makeAbsolute());
                System.out.println(inProject ? "\tinProject" : "Not in Project");
                Object temp = "";
                if (inProject) {
                    temp = "$main_root/" + path.makeRelative().removeFirstSegments(1).toOSString();
                    temp = ((String)temp).trim();
                    if (this.contain(classPath, (String)(temp = ((String)temp).replace('\\', '/').trim()))) break;
                    classPath.add(temp);
                    System.out.println("\tadded to ClassPath: " + (String)temp);
                    break;
                }
                temp = path.makeAbsolute().toOSString();
                temp = ((String)temp).trim();
                break;
            }
            default: {
                System.out.println("\t**Non-CPE_LIBRARY class path entry: " + path.toOSString());
            }
        }
        return classPath;
    }

    private boolean contain(ArrayList classPath, String classPathEntryString) {
        boolean contain = false;
        if (classPathEntryString != null) {
            Iterator itr = classPath.iterator();
            while (itr.hasNext()) {
                if (!classPathEntryString.equalsIgnoreCase((String)itr.next())) continue;
                contain = true;
                break;
            }
        }
        return contain;
    }

    private void dialogChanged() {
        this.gr.setEnabled(true);
        this.osCombo.setEnabled(true);
        this.jdkVersionCombo.setEnabled(true);
        this.gr1.setEnabled(true);
        this.viewer.table.setEnabled(true);
        this.viewer.add.setEnabled(true);
        this.viewer.delete.setEnabled(true);
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

