/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.AppendMSPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.LazyIterableIterator;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class FrameAppendMSPInstruction
extends AppendMSPInstruction {
    protected FrameAppendMSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand offset, CPOperand out, boolean cbind, String opcode, String istr) {
        super(op, in1, in2, offset, out, cbind, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        this.checkBinaryAppendInputCharacteristics(sec, this._cbind, false, false);
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        PartitionedBroadcast<FrameBlock> in2 = sec.getBroadcastForFrameVariable(this.input2.getName());
        JavaPairRDD<Long, FrameBlock> out = null;
        if (!FrameAppendMSPInstruction.preservesPartitioning(this._cbind)) {
            throw new DMLRuntimeException("Append type rbind not supported for frame mappend, instead use rappend");
        }
        out = FrameAppendMSPInstruction.appendFrameMSP(in1, in2);
        this.updateBinaryAppendOutputDataCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageBroadcast(this.output.getName(), this.input2.getName());
        if (this._cbind) {
            sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).mergeSchemas(sec.getFrameObject(this.input2.getName())));
        } else {
            sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).getSchema());
        }
    }

    public static JavaPairRDD<Long, FrameBlock> appendFrameMSP(JavaPairRDD<Long, FrameBlock> in1, PartitionedBroadcast<FrameBlock> in2) {
        JavaPairRDD<Long, FrameBlock> out = in1.mapPartitionsToPair(new MapSideAppendPartitionFunction(in2), true);
        return out;
    }

    private static boolean preservesPartitioning(boolean cbind) {
        return cbind;
    }

    private static class MapSideAppendPartitionFunction
    implements PairFlatMapFunction<Iterator<Tuple2<Long, FrameBlock>>, Long, FrameBlock> {
        private static final long serialVersionUID = -3997051891171313830L;
        private PartitionedBroadcast<FrameBlock> _pm = null;

        public MapSideAppendPartitionFunction(PartitionedBroadcast<FrameBlock> binput) {
            this._pm = binput;
        }

        public LazyIterableIterator<Tuple2<Long, FrameBlock>> call(Iterator<Tuple2<Long, FrameBlock>> arg0) throws Exception {
            return new MapAppendPartitionIterator(arg0);
        }

        private class MapAppendPartitionIterator
        extends LazyIterableIterator<Tuple2<Long, FrameBlock>> {
            public MapAppendPartitionIterator(Iterator<Tuple2<Long, FrameBlock>> in) {
                super(in);
            }

            @Override
            protected Tuple2<Long, FrameBlock> computeNext(Tuple2<Long, FrameBlock> arg) throws Exception {
                Long ix = (Long)arg._1();
                FrameBlock in1 = (FrameBlock)arg._2();
                int rowix = (ix.intValue() - 1) / 1000 + 1;
                int colix = 1;
                FrameBlock in2 = MapSideAppendPartitionFunction.this._pm.getBlock(rowix, colix);
                if (in1.getNumRows() != in2.getNumRows()) {
                    int start = ix.intValue() - 1 - (rowix - 1) * 1000;
                    int end = start + in1.getNumRows() - 1;
                    in2 = in2.slice(start, end);
                }
                FrameBlock out = in1.append(in2, true);
                return new Tuple2((Object)ix, (Object)out);
            }
        }
    }
}

