/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockLDRB;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockLFP64DEDUP
extends DenseBlockLDRB {
    private static final long serialVersionUID = -3437790596644064171L;
    private double[][] _data;

    protected DenseBlockLFP64DEDUP(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlocks(int numBlocks) {
        this._data = new double[numBlocks][];
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data[bix] = new double[length];
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        if ((long)rlen > this.capacity() / (long)this._odims[0]) {
            this.allocateBlocks(rlen);
            if (v != 0.0) {
                for (int i = 0; i < rlen; ++i) {
                    this.allocateBlock(i, odims[0]);
                    Arrays.fill(this._data[i], 0, odims[0], v);
                }
            }
        } else if (v == 0.0) {
            for (int i = 0; i < rlen; ++i) {
                this._data[i] = null;
            }
        } else {
            for (int i = 0; i < rlen; ++i) {
                if (odims[0] > this._odims[0] || this._data[i] == null) {
                    this.allocateBlock(i, odims[0]);
                }
                Arrays.fill(this._data[i], 0, odims[0], v);
            }
        }
        this._blen = 1;
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.FP64 == vt;
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)(this._data.length * this._odims[0]) : -1L;
    }

    @Override
    public long countNonZeros() {
        long nnz = 0L;
        HashMap<double[], Long> cache = new HashMap<double[], Long>();
        for (int i = 0; i < this._rlen; ++i) {
            double[] row = this._data[i];
            if (row == null) continue;
            Long count = cache.getOrDefault(row, null);
            if (count == null) {
                count = this.countNonZeros(i);
                cache.put(row, count);
            }
            nnz += count.longValue();
        }
        return nnz;
    }

    @Override
    public int countNonZeros(int r) {
        return this._data[r] == null ? 0 : UtilFunctions.computeNnz(this._data[r], 0, this._odims[0]);
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        int nnz = 0;
        int row_start = (int)Math.floor(start / this._odims[0]);
        int col_start = start % this._odims[0];
        for (int i = 0; i < length; ++i) {
            if (this._data[row_start] == null) {
                i += this._odims[0] - 1 - col_start;
                col_start = 0;
                ++row_start;
                continue;
            }
            nnz += this._data[row_start][col_start] != 0.0 ? 1 : 0;
            if (++col_start != this._odims[0]) continue;
            col_start = 0;
            ++row_start;
        }
        return nnz;
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    @Override
    public double[] values(int r) {
        if (this._data[r] == null) {
            this.allocateBlock(r, this._odims[0]);
        }
        return this._data[r];
    }

    @Override
    public double[] valuesAt(int bix) {
        return this.values(bix);
    }

    @Override
    public int numBlocks() {
        return this._data.length;
    }

    @Override
    public void incr(int r, int c) {
        throw new NotImplementedException();
    }

    @Override
    public void incr(int r, int c, double delta) {
        throw new NotImplementedException();
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        throw new NotImplementedException();
    }

    @Override
    public void fillRow(int r, double v) {
        throw new NotImplementedException();
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        if (this._data[r] == null) {
            this._data[r] = new double[this._odims[0]];
        }
        this._data[r][c] = v;
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        if (v.length != this._odims[0]) {
            throw new RuntimeException("set Denseblock called with an array length [" + v.length + "], array to overwrite is of length [" + this._odims[0] + "]");
        }
        this._data[r] = v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        throw new NotImplementedException();
    }

    @Override
    public double get(int r, int c) {
        return this._data[r][c];
    }

    @Override
    public double get(int[] ix) {
        throw new NotImplementedException();
    }

    @Override
    public String getString(int[] ix) {
        throw new NotImplementedException();
    }

    @Override
    public long getLong(int[] ix) {
        throw new NotImplementedException();
    }
}

