/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.compress;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;

public class ArrayCompressionStatistics {
    public final long originalSize;
    public final long compressedSizeEstimate;
    public final boolean shouldCompress;
    public final Types.ValueType valueType;
    public final boolean containsNull;
    public final ArrayFactory.FrameArrayType bestType;
    public final int bytePerValue;
    public final int nUnique;

    public ArrayCompressionStatistics(int bytePerValue, int nUnique, boolean shouldCompress, Types.ValueType valueType, boolean containsNull, ArrayFactory.FrameArrayType bestType, long originalSize, long compressedSizeEstimate) {
        this.bytePerValue = bytePerValue;
        this.nUnique = nUnique;
        this.shouldCompress = shouldCompress;
        this.valueType = valueType;
        this.containsNull = containsNull;
        this.bestType = bestType;
        this.originalSize = originalSize;
        this.compressedSizeEstimate = compressedSizeEstimate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Compressed Stats: size:%8d->%8d, Use:%10s, Unique:%6d, ValueType:%7s", new Object[]{this.originalSize, this.compressedSizeEstimate, this.bestType == null ? "None" : this.bestType.toString(), this.nUnique, this.valueType}));
        return sb.toString();
    }
}

