/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;

public class CoCodeHybrid
extends AColumnCoCoder {
    protected CoCodeHybrid(CompressedSizeEstimator sizeEstimator, ICostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        int startSize = colInfos.getInfo().size();
        int PriorityQueGoal = startSize / 5;
        LOG.debug((Object)"Using Hybrid Cocode Strategy: ");
        if (startSize == 1) {
            return colInfos;
        }
        if (startSize > 1000) {
            colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, 1));
        } else if (startSize <= 5) {
            colInfos.setInfo(CoCodeGreedy.join(colInfos.getInfo(), this._sest, this._cest, this._cs, k));
        } else if (PriorityQueGoal > 30) {
            Timing time = new Timing(true);
            colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, PriorityQueGoal));
            LOG.debug((Object)("Que based time: " + time.stop()));
            int pqSize = colInfos.getInfo().size();
            if (pqSize <= PriorityQueGoal * 2) {
                time = new Timing(true);
                colInfos.setInfo(CoCodeGreedy.join(colInfos.getInfo(), this._sest, this._cest, this._cs, k));
                LOG.debug((Object)("Greedy time:     " + time.stop()));
            }
        } else {
            colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, 1));
        }
        return colInfos;
    }
}

