/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.spark_project.jetty.http.HttpMethod;
import org.spark_project.jetty.util.IO;
import org.spark_project.jetty.util.MultiMap;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.UrlEncoded;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class CGI
extends HttpServlet {
    private static final long serialVersionUID = -6182088932884791074L;
    private static final Logger LOG = Log.getLogger(CGI.class);
    private boolean _ok;
    private File _docRoot;
    private boolean _cgiBinProvided;
    private String _path;
    private String _cmdPrefix;
    private boolean _useFullPath;
    private EnvList _env;
    private boolean _ignoreExitState;
    private boolean _relative;

    public void init() throws ServletException {
        String os;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        this._useFullPath = Boolean.parseBoolean(this.getInitParameter("useFullPath"));
        this._relative = Boolean.parseBoolean(this.getInitParameter("cgibinResourceBaseIsRelative"));
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp != null) {
            this._cgiBinProvided = true;
        } else {
            tmp = this.getInitParameter("resourceBase");
            if (tmp != null) {
                this._cgiBinProvided = true;
            } else {
                tmp = this.getServletContext().getRealPath("/");
            }
        }
        if (this._relative && this._cgiBinProvided) {
            tmp = this.getServletContext().getRealPath(tmp);
        }
        if (tmp == null) {
            LOG.warn("CGI: no CGI bin !", new Object[0]);
            return;
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            LOG.warn("CGI: CGI bin does not exist - " + dir, new Object[0]);
            return;
        }
        if (!dir.canRead()) {
            LOG.warn("CGI: CGI bin is not readable - " + dir, new Object[0]);
            return;
        }
        if (!dir.isDirectory()) {
            LOG.warn("CGI: CGI bin is not a directory - " + dir, new Object[0]);
            return;
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.warn("CGI: CGI bin failed - " + dir, e);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (os = System.getProperty("os.name")) != null && os.toLowerCase(Locale.ENGLISH).indexOf("windows") != -1) {
            this._env.set("SystemRoot", "C:\\WINDOWS");
        }
        this._ok = true;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this._ok) {
            res.sendError(503);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: ContextPath : " + req.getContextPath(), new Object[0]);
            LOG.debug("CGI: ServletPath : " + req.getServletPath(), new Object[0]);
            LOG.debug("CGI: PathInfo    : " + req.getPathInfo(), new Object[0]);
            LOG.debug("CGI: _docRoot    : " + this._docRoot, new Object[0]);
            LOG.debug("CGI: _path       : " + this._path, new Object[0]);
            LOG.debug("CGI: _ignoreExitState: " + this._ignoreExitState, new Object[0]);
        }
        String pathInContext = (this._relative ? "" : StringUtil.nonNull(req.getServletPath())) + StringUtil.nonNull(req.getPathInfo());
        File execCmd = new File(this._docRoot, pathInContext);
        String pathInfo = pathInContext;
        if (!this._useFullPath) {
            String path = pathInContext;
            String info = "";
            while ((path.endsWith("/") || !execCmd.exists()) && path.length() >= 0) {
                int index = path.lastIndexOf(47);
                path = path.substring(0, index);
                info = pathInContext.substring(index, pathInContext.length());
                execCmd = new File(this._docRoot, path);
            }
            if (path.length() == 0 || !execCmd.exists() || execCmd.isDirectory() || !execCmd.getCanonicalPath().equals(execCmd.getAbsolutePath())) {
                res.sendError(404);
            }
            pathInfo = info;
        }
        this.exec(execCmd, pathInfo, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String absolutePath;
        String scriptName;
        String scriptPath;
        String pathTranslated;
        assert (req != null);
        assert (res != null);
        assert (pathInfo != null);
        assert (command != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: script is " + command, new Object[0]);
            LOG.debug("CGI: pathInfo is " + pathInfo, new Object[0]);
        }
        String bodyFormEncoded = null;
        if ((HttpMethod.POST.equals(req.getMethod()) || HttpMethod.PUT.equals(req.getMethod())) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            MultiMap<String> parameterMap = new MultiMap<String>();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String parameterName = (String)names.nextElement();
                parameterMap.addValues(parameterName, (String[])req.getParameterValues(parameterName));
            }
            bodyFormEncoded = UrlEncoded.encode(parameterMap, Charset.forName(req.getCharacterEncoding()), true);
        }
        EnvList env = new EnvList(this._env);
        env.set("AUTH_TYPE", req.getAuthType());
        int contentLen = req.getContentLength();
        if (contentLen < 0) {
            contentLen = 0;
        }
        if (bodyFormEncoded != null) {
            env.set("CONTENT_LENGTH", Integer.toString(bodyFormEncoded.length()));
        } else {
            env.set("CONTENT_LENGTH", Integer.toString(contentLen));
        }
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        if (pathInfo.length() > 0) {
            env.set("PATH_INFO", pathInfo);
        }
        if ((pathTranslated = req.getPathTranslated()) == null || pathTranslated.length() == 0) {
            pathTranslated = pathInfo;
        }
        env.set("PATH_TRANSLATED", pathTranslated);
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("REMOTE_USER", req.getRemoteUser());
        env.set("REQUEST_METHOD", req.getMethod());
        if (this._cgiBinProvided) {
            scriptPath = command.getAbsolutePath();
            scriptName = scriptPath.substring(this._docRoot.getAbsolutePath().length());
        } else {
            String requestURI = req.getRequestURI();
            scriptName = requestURI.substring(0, requestURI.length() - pathInfo.length());
            scriptPath = this.getServletContext().getRealPath(scriptName);
        }
        env.set("SCRIPT_FILENAME", scriptPath);
        env.set("SCRIPT_NAME", scriptName);
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String value2 = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase(Locale.ENGLISH).replace('-', '_'), value2);
        }
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        String execCmd = absolutePath = command.getAbsolutePath();
        if (execCmd.length() > 0 && execCmd.charAt(0) != '\"' && execCmd.indexOf(" ") >= 0) {
            execCmd = "\"" + execCmd + "\"";
        }
        if (this._cmdPrefix != null) {
            execCmd = this._cmdPrefix + " " + execCmd;
        }
        assert (execCmd != null);
        LOG.debug("Environment: " + env.getExportString(), new Object[0]);
        LOG.debug("Command: " + execCmd, new Object[0]);
        final Process p = Runtime.getRuntime().exec(execCmd, env.getEnvArray(), this._docRoot);
        if (bodyFormEncoded != null) {
            CGI.writeProcessInput(p, bodyFormEncoded);
        } else if (contentLen > 0) {
            CGI.writeProcessInput(p, (InputStream)req.getInputStream(), contentLen);
        }
        OutputStream os = null;
        AsyncContext async = req.startAsync();
        try {
            int exitValue;
            async.start(new Runnable(){

                @Override
                public void run() {
                    try {
                        IO.copy(p.getErrorStream(), System.err);
                    }
                    catch (IOException e) {
                        LOG.warn(e);
                    }
                }
            });
            String line = null;
            InputStream inFromCgi = p.getInputStream();
            while ((line = CGI.getTextLineFromStream(inFromCgi)).length() > 0) {
                int k;
                if (line.startsWith("HTTP") || (k = line.indexOf(58)) <= 0) continue;
                String key = line.substring(0, k).trim();
                String value3 = line.substring(k + 1).trim();
                if ("Location".equals(key)) {
                    res.sendRedirect(res.encodeRedirectURL(value3));
                    continue;
                }
                if ("Status".equals(key)) {
                    String[] token = value3.split(" ");
                    int status = Integer.parseInt(token[0]);
                    res.setStatus(status);
                    continue;
                }
                res.addHeader(key, value3);
            }
            os = res.getOutputStream();
            IO.copy(inFromCgi, os);
            p.waitFor();
            if (!this._ignoreExitState && 0 != (exitValue = p.exitValue())) {
                LOG.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + absolutePath, new Object[0]);
                if (!res.isCommitted()) {
                    res.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException e) {
            LOG.debug("CGI: Client closed connection!", e);
        }
        catch (InterruptedException ie) {
            LOG.debug("CGI: interrupted!", new Object[0]);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    LOG.debug(e);
                }
            }
            p.destroy();
            async.complete();
        }
    }

    private static void writeProcessInput(final Process p, final String input) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try (OutputStreamWriter outToCgi = new OutputStreamWriter(p.getOutputStream());){
                    outToCgi.write(input);
                }
                catch (IOException e) {
                    LOG.debug(e);
                }
            }
        }).start();
    }

    private static void writeProcessInput(final Process p, final InputStream input, final int len) {
        if (len <= 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutputStream outToCgi = p.getOutputStream();
                    IO.copy(input, outToCgi, (long)len);
                    outToCgi.close();
                }
                catch (IOException e) {
                    LOG.debug(e);
                }
            }
        }).start();
    }

    private static String getTextLineFromStream(InputStream is) throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while ((b = is.read()) != -1 && b != 10) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    private static class EnvList {
        private Map<String, String> envMap;

        EnvList() {
            this.envMap = new HashMap<String, String>();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap<String, String>(l.envMap);
        }

        public void set(String name, String value2) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull(value2));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String getExportString() {
            StringBuilder sb = new StringBuilder();
            for (String variable : this.getEnvArray()) {
                sb.append("export \"");
                sb.append(variable);
                sb.append("\"; ");
            }
            return sb.toString();
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

