/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.common.entity;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.RelationshipTypeExtension;

public class UMembershipType implements RelationshipType {

    private static final long serialVersionUID = -1709576534307375338L;

    public static final String KEY = "UMembership";

    private static final UMembershipType INSTANCE = new UMembershipType();

    public static UMembershipType getInstance() {
        return INSTANCE;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void setKey(final String key) {
        // cannot be changed
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setDescription(final String description) {
        // cannot be changed    
    }

    @Override
    public AnyType getLeftEndAnyType() {
        return ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class).getUser();
    }

    @Override
    public void setLeftEndAnyType(final AnyType anyType) {
        // cannot be changed
    }

    @Override
    public AnyType getRightEndAnyType() {
        return ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class).getGroup();
    }

    @Override
    public void setRightEndAnyType(final AnyType anyType) {
        // cannot be changed
    }

    @Override
    public boolean add(final RelationshipTypeExtension typeExtension) {
        return false;
    }

    @Override
    public Optional<? extends RelationshipTypeExtension> getTypeExtension(final AnyType anyType) {
        return Optional.empty();
    }

    @Override
    public List<? extends RelationshipTypeExtension> getTypeExtensions() {
        return List.of();
    }
}
