/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallerFactory {
    private final Logger log = LoggerFactory.getLogger(UnmarshallerFactory.class);
    private Map<QName, Unmarshaller> unmarshallers = new ConcurrentHashMap<QName, Unmarshaller>();

    public Unmarshaller getUnmarshaller(QName key) {
        if (key == null) {
            return null;
        }
        return this.unmarshallers.get(key);
    }

    public Unmarshaller getUnmarshaller(Element domElement) {
        Unmarshaller unmarshaller = this.getUnmarshaller(XMLHelper.getXSIType(domElement));
        if (unmarshaller == null) {
            unmarshaller = this.getUnmarshaller(XMLHelper.getNodeQName(domElement));
        }
        return unmarshaller;
    }

    public Map<QName, Unmarshaller> getUnmarshallers() {
        return Collections.unmodifiableMap(this.unmarshallers);
    }

    public void registerUnmarshaller(QName key, Unmarshaller unmarshaller) {
        this.log.debug("Registering unmarshaller, {}, for object type, {}", (Object)unmarshaller.getClass().getName(), (Object)key);
        if (key == null) {
            throw new IllegalArgumentException("Unmarshaller key may not be null");
        }
        this.unmarshallers.put(key, unmarshaller);
    }

    public Unmarshaller deregisterUnmarshaller(QName key) {
        this.log.debug("Deregistering marshaller for object type {}", (Object)key);
        if (key != null) {
            return this.unmarshallers.remove(key);
        }
        return null;
    }
}

