/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.endpoints.Endpoint;

public class EndpointDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(EndpointDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint Deployment from file : " + fileName + " : Started"));
        }
        try {
            Endpoint ep = EndpointFactory.getEndpointFromElement(artifactConfig, false, properties);
            if (ep != null) {
                ep.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint named '" + ep.getName() + "' has been built from the file " + fileName));
                }
                ep.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the endpoint : " + ep.getName()));
                }
                this.getSynapseConfiguration().addEndpoint(ep.getName(), ep);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Endpoint named '" + ep.getName() + "' has been deployed from file : " + fileName));
                return ep.getName();
            }
            this.handleSynapseArtifactDeploymentError("Endpoint Deployment Failed. The artifact described in the file " + fileName + " is not an Endpoint");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Endpoint Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint update from file : " + fileName + " has started"));
        }
        try {
            Endpoint ep = EndpointFactory.getEndpointFromElement(artifactConfig, false, properties);
            if (ep == null) {
                this.handleSynapseArtifactDeploymentError("Endpoint update failed. The artifact defined in the file: " + fileName + " is not a valid endpoint.");
                return null;
            }
            ep.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint: " + ep.getName() + " has been built from the file: " + fileName));
            }
            ep.init(this.getSynapseEnvironment());
            Endpoint existingEp = this.getSynapseConfiguration().getDefinedEndpoints().get(existingArtifactName);
            if (existingArtifactName.equals(ep.getName())) {
                this.getSynapseConfiguration().updateEndpoint(existingArtifactName, ep);
            } else {
                this.getSynapseConfiguration().addEndpoint(ep.getName(), ep);
                this.getSynapseConfiguration().removeEndpoint(existingArtifactName);
                log.info((Object)("Endpoint: " + existingArtifactName + " has been undeployed"));
            }
            log.info((Object)("Endpoint: " + ep.getName() + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            existingEp.destroy();
            if (existingArtifactName.equals(ep.getName())) {
                MBeanRegistrar.getInstance().registerMBean((Object)ep.getMetricsMBean(), "Endpoint", ep.getName());
            }
            return ep.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the endpoint from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint Undeployment of the endpoint named : " + artifactName + " : Started"));
        }
        try {
            Endpoint ep = this.getSynapseConfiguration().getDefinedEndpoints().get(artifactName);
            if (ep != null) {
                this.getSynapseConfiguration().removeEndpoint(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the endpoint named : " + artifactName));
                }
                ep.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint Undeployment of the endpoint named : " + artifactName + " : Completed"));
                }
                log.info((Object)("Endpoint named '" + ep.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Endpoint Undeployement of endpoint named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the Endpoint with name : " + artifactName + " : Started"));
        }
        try {
            Endpoint ep = this.getSynapseConfiguration().getDefinedEndpoints().get(artifactName);
            OMElement epElem = EndpointSerializer.getElementFromEndpoint(ep);
            if (ep.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "endpoints" + File.separator + ep.getFileName();
                this.writeToFile(epElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the Endpoint with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("Endpoint named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the endpoint named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the endpoint named '" + artifactName + "' has failed", e);
        }
    }
}

