/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors.config;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.executors.BeforeExecuteHandler;
import org.apache.synapse.commons.executors.InternalQueue;
import org.apache.synapse.commons.executors.MultiPriorityBlockingQueue;
import org.apache.synapse.commons.executors.NextQueueAlgorithm;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.queues.FixedSizeQueue;
import org.apache.synapse.commons.executors.queues.UnboundedQueue;

public class PriorityExecutorFactory {
    private static Log log = LogFactory.getLog(PriorityExecutorFactory.class);
    public static final QName NAME_ATT = new QName("name");
    public static final QName SIZE_ATT = new QName("size");
    public static final QName PRIORITY_ATT = new QName("priority");
    public static final QName IS_FIXED_ATT = new QName("isFixedSize");
    public static final QName BEFORE_EXECUTE_HANDLER = new QName("beforeExecuteHandler");
    public static final QName NEXT_QUEUE_ATT = new QName("nextQueue");
    public static final QName MAX_ATT = new QName("max");
    public static final QName CORE_ATT = new QName("core");
    public static final QName KEEP_ALIVE_ATT = new QName("keep-alive");

    public static PriorityExecutor createExecutor(String namespace, OMElement e, boolean requireName, Properties properties) throws AxisFault {
        OMElement queuesEle;
        QName queuesQName = PriorityExecutorFactory.createQname(namespace, "queues");
        QName queueQName = PriorityExecutorFactory.createQname(namespace, "queue");
        QName threadsQName = PriorityExecutorFactory.createQname(namespace, "threads");
        PriorityExecutor executor = new PriorityExecutor();
        OMAttribute nameAtt = e.getAttribute(NAME_ATT);
        if (nameAtt != null && !"".equals(nameAtt.getAttributeValue())) {
            executor.setName(nameAtt.getAttributeValue());
        } else if (requireName) {
            PriorityExecutorFactory.handlerException("name is required for a priorityExecutor");
        }
        OMAttribute handlerAtt = e.getAttribute(BEFORE_EXECUTE_HANDLER);
        if (handlerAtt != null) {
            BeforeExecuteHandler beh = PriorityExecutorFactory.createExecuteBeforeHandler(handlerAtt.getAttributeValue());
            executor.setBeforeExecuteHandler(beh);
        }
        if ((queuesEle = e.getFirstChildWithName(queuesQName)) != null) {
            OMAttribute nextQueueAtt = queuesEle.getAttribute(NEXT_QUEUE_ATT);
            NextQueueAlgorithm<Runnable> nqa = null;
            if (nextQueueAtt != null) {
                nqa = PriorityExecutorFactory.createNextQueueAlgo(nextQueueAtt.getAttributeValue());
            }
            boolean isFixedSize = true;
            OMAttribute fixedSizeAtt = queuesEle.getAttribute(IS_FIXED_ATT);
            if (fixedSizeAtt != null) {
                isFixedSize = Boolean.parseBoolean(fixedSizeAtt.getAttributeValue());
            }
            List intQueues = PriorityExecutorFactory.createQueues(queueQName, queuesEle, isFixedSize);
            MultiPriorityBlockingQueue<Runnable> queue = new MultiPriorityBlockingQueue<Runnable>(intQueues, isFixedSize, nqa);
            executor.setQueue(queue);
        } else {
            PriorityExecutorFactory.handlerException("Queues configuration is mandatory");
        }
        OMElement threadsEle = e.getFirstChildWithName(threadsQName);
        if (threadsEle != null) {
            OMAttribute keepAliveAttr;
            OMAttribute coreAttr;
            OMAttribute maxAttr = threadsEle.getAttribute(MAX_ATT);
            if (maxAttr != null) {
                executor.setMax(Integer.parseInt(maxAttr.getAttributeValue()));
            }
            if ((coreAttr = threadsEle.getAttribute(CORE_ATT)) != null) {
                executor.setCore(Integer.parseInt(coreAttr.getAttributeValue()));
            }
            if ((keepAliveAttr = threadsEle.getAttribute(KEEP_ALIVE_ATT)) != null) {
                executor.setKeepAlive(Integer.parseInt(keepAliveAttr.getAttributeValue()));
            }
        }
        return executor;
    }

    private static List<InternalQueue<Runnable>> createQueues(QName qQName, OMElement queuesEle, boolean isFixedSize) throws AxisFault {
        ArrayList<InternalQueue<Runnable>> internalQueues = new ArrayList<InternalQueue<Runnable>>();
        Iterator it = queuesEle.getChildrenWithName(qQName);
        while (it.hasNext()) {
            OMElement qElement = (OMElement)it.next();
            String size = qElement.getAttributeValue(SIZE_ATT);
            String priority = qElement.getAttributeValue(PRIORITY_ATT);
            int s = 0;
            int p = 0;
            if (priority != null) {
                p = Integer.parseInt(priority);
            } else {
                PriorityExecutorFactory.handlerException("Priority must be specified");
            }
            if (size != null) {
                s = Integer.parseInt(size);
                isFixedSize = true;
            } else if (isFixedSize) {
                PriorityExecutorFactory.handlerException("Queues should have a size");
            }
            AbstractQueue queue = isFixedSize ? new FixedSizeQueue(p, s) : new UnboundedQueue(p);
            internalQueues.add((InternalQueue<Runnable>)((Object)queue));
        }
        return internalQueues;
    }

    private static BeforeExecuteHandler createExecuteBeforeHandler(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof BeforeExecuteHandler) {
                return (BeforeExecuteHandler)o;
            }
            PriorityExecutorFactory.handlerException("Before execute handler class, " + className + " is not type of BeforeExecuteHandler");
        }
        catch (ClassNotFoundException e1) {
            PriorityExecutorFactory.handlerException("Before execute handler class, " + className + " is not found");
        }
        catch (IllegalAccessException e1) {
            PriorityExecutorFactory.handlerException("Before execute handler class, " + className + " cannot be accessed");
        }
        catch (InstantiationException e1) {
            PriorityExecutorFactory.handlerException("Before execute handler class, " + className + " cannot be instantiated");
        }
        return null;
    }

    private static NextQueueAlgorithm<Runnable> createNextQueueAlgo(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof NextQueueAlgorithm) {
                return (NextQueueAlgorithm)o;
            }
            PriorityExecutorFactory.handlerException("NextQueue algorithm class, " + className + " is not type of BeforeExecuteHandler");
        }
        catch (ClassNotFoundException e1) {
            PriorityExecutorFactory.handlerException("NextQueue algorithm class, " + className + " is not found");
        }
        catch (IllegalAccessException e1) {
            PriorityExecutorFactory.handlerException("NextQueue algorithm class, " + className + " cannot be accessed");
        }
        catch (InstantiationException e1) {
            PriorityExecutorFactory.handlerException("NextQueue algorithm class, " + className + " cannot be instantiated");
        }
        return null;
    }

    private static QName createQname(String namespace, String name) {
        if (namespace == null) {
            return new QName(name);
        }
        return new QName(namespace, name);
    }

    private static void handlerException(String message) throws AxisFault {
        log.error((Object)message);
        throw new AxisFault(message);
    }
}

