/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final String CGLIB_CLASS_SEPARATOR_CHAR = "$$";
    static /* synthetic */ Class class$org$springframework$util$ClassUtils;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$springframework$util$ClassUtils == null ? (class$org$springframework$util$ClassUtils = ClassUtils.class$("org.springframework.util.ClassUtils")) : class$org$springframework$util$ClassUtils).getClassLoader();
        }
        return cl;
    }

    public static Class forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String name) {
        if (name.length() <= 8) {
            for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                Class clazz = PRIMITIVE_CLASSES[i];
                if (!clazz.getName().equals(name)) continue;
                return clazz;
            }
        }
        return null;
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR_CHAR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getQualifiedName(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isArray()) {
            return clazz.getComponentType().getName() + ARRAY_SUFFIX;
        }
        return clazz.getName();
    }

    public static String getQualifiedMethodName(Method method) {
        Assert.notNull(method, "Method must not be empty");
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static boolean hasMethod(Class clazz, String methodName, Class[] paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            clazz.getMethod(methodName, paramTypes);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static int getMethodCountForName(Class clazz, String methodName) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        int count = 0;
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!methodName.equals(method.getName())) continue;
                ++count;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return count;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String methodName) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static Method getStaticMethod(Class clazz, String methodName, Class[] args) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            Method method = clazz.getDeclaredMethod(methodName, args);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static String addResourcePathToPackagePath(Class clazz, String resourceName) {
        Assert.notNull(resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Class[] getAllInterfaces(Object object) {
        Set interfaces = ClassUtils.getAllInterfacesAsSet(object);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Set interfaces = ClassUtils.getAllInterfacesForClassAsSet(clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Set getAllInterfacesAsSet(Object object) {
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set getAllInterfacesForClassAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet interfaces = new HashSet();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> ifc = clazz.getInterfaces()[i];
                interfaces.add(ifc);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

