/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.debug;

import java.net.InetAddress;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.debug.AbstractConnectionDebug;
import org.apache.synapse.transport.nhttp.debug.ClientConnectionDebug;

public class ServerConnectionDebug
extends AbstractConnectionDebug {
    private long connectionCreationTime;
    private long requestStartTime;
    private long requestCompletionTime;
    private long responseStartTime;
    private long responseCompletionTime;
    private String remoteClientIP;
    private String requestURLPAth;
    private String requestHTTPMethod;
    private String requestHTTPProtocol;
    private ClientConnectionDebug clientConnectionDebug = null;

    public ServerConnectionDebug(NHttpServerConnection conn) {
        HttpInetConnection inetConn;
        InetAddress remoteAddr;
        this.connectionCreationTime = (Long)conn.getContext().getAttribute("synapse.connectionCreationTime");
        this.requestStartTime = System.currentTimeMillis();
        this.requestCompletionTime = System.currentTimeMillis();
        RequestLine reqLine = conn.getHttpRequest().getRequestLine();
        this.requestURLPAth = reqLine.getUri();
        this.requestHTTPMethod = reqLine.getMethod();
        this.requestHTTPProtocol = reqLine.getProtocolVersion().toString();
        if (conn instanceof HttpInetConnection && (remoteAddr = (inetConn = (HttpInetConnection)conn).getRemoteAddress()) != null) {
            this.remoteClientIP = remoteAddr.getHostAddress();
        }
        HttpRequest req = conn.getHttpRequest();
        this.headers = req.getAllHeaders();
    }

    public void recordResponseStartTime() {
        this.responseStartTime = System.currentTimeMillis();
    }

    public void recordRequestCompletionTime() {
        this.requestCompletionTime = System.currentTimeMillis();
    }

    public void recordResponseCompletionTime() {
        this.responseCompletionTime = System.currentTimeMillis();
    }

    public void setClientConnectionDebug(ClientConnectionDebug clientConnectionDebug) {
        this.clientConnectionDebug = clientConnectionDebug;
    }

    public ClientConnectionDebug getClientConnectionDebug() {
        return this.clientConnectionDebug;
    }

    @Override
    public String dump() {
        StringBuffer sb = new StringBuffer(50);
        this.responseCompletionTime = this.responseCompletionTime == 0L ? System.currentTimeMillis() : this.responseCompletionTime;
        long totalTime = this.responseCompletionTime - this.requestStartTime;
        sb.append("C2E-Req-StartTime").append(this.keyValueSeparator).append(this.format(this.requestStartTime));
        sb.append(this.fieldSeparator);
        sb.append("C2E-Req-EndTime").append(this.keyValueSeparator).append(this.format(this.requestCompletionTime));
        sb.append(this.fieldSeparator);
        sb.append("C2E-Req-ConnCreateTime").append(this.keyValueSeparator).append(this.format(this.connectionCreationTime));
        sb.append(this.statementSeparator);
        sb.append("C2E-Req-URL").append(this.keyValueSeparator).append(this.requestURLPAth);
        sb.append(this.fieldSeparator);
        sb.append("C2E-Req-Protocol").append(this.keyValueSeparator).append(this.requestHTTPProtocol);
        sb.append(this.fieldSeparator);
        sb.append("C2E-Req-Method").append(this.keyValueSeparator).append(this.requestHTTPMethod);
        sb.append(this.statementSeparator);
        sb.append("C2E-Req-IP").append(this.keyValueSeparator).append(this.remoteClientIP);
        if (!this.printNoHeaders) {
            sb.append(this.fieldSeparator);
            sb.append("C2E-Req-Info").append("{").append(this.headersToString()).append("}");
        }
        sb.append(this.statementSeparator);
        if (this.clientConnectionDebug != null) {
            sb.append(this.clientConnectionDebug.dump());
        }
        sb.append("E2C-Resp-Start").append(this.keyValueSeparator).append(this.format(this.responseStartTime));
        sb.append(this.fieldSeparator);
        sb.append("E2C-Resp-End").append(this.keyValueSeparator).append(this.format(this.responseCompletionTime));
        sb.append(this.statementSeparator);
        sb.append("Total-Time").append(this.keyValueSeparator).append(totalTime).append("ms");
        if (this.clientConnectionDebug != null) {
            long svcTime = this.clientConnectionDebug.getResponseCompletionTime() - this.clientConnectionDebug.getLastRequestStartTime();
            svcTime = svcTime < 0L ? this.clientConnectionDebug.getResponseStartTime() - this.clientConnectionDebug.getLastRequestStartTime() : svcTime;
            sb.append(this.fieldSeparator);
            sb.append("Svc-Time").append(this.keyValueSeparator).append(svcTime > 0L ? Long.toString(svcTime) + "ms" : "UNDETERMINED");
            sb.append(this.fieldSeparator);
            sb.append("ESB-Time").append(this.keyValueSeparator).append(svcTime > 0L ? Long.toString(totalTime - svcTime) + "ms" : "UNDETERMINED");
        }
        return sb.toString();
    }
}

