/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.caching.CachableResponse;
import org.wso2.caching.CacheReplicationCommand;
import org.wso2.caching.RequestHash;
import org.wso2.caching.ServiceName;

public class CacheManager {
    private Map<ServiceName, Map<RequestHash, CachableResponse>> cache = new ConcurrentHashMap<ServiceName, Map<RequestHash, CachableResponse>>();

    public synchronized void removeExpiredResponses(ServiceName serviceName, CacheReplicationCommand cacheReplicationCommand) {
        Map<RequestHash, CachableResponse> responseMap = this.cache.get(serviceName);
        for (Map.Entry<RequestHash, CachableResponse> entry : responseMap.entrySet()) {
            if (!entry.getValue().isExpired() || entry.getValue().isInUse()) continue;
            responseMap.remove(entry.getKey());
            cacheReplicationCommand.removeCachedResponse(serviceName, entry.getKey());
        }
        if (responseMap.isEmpty()) {
            this.cache.remove(serviceName);
        }
    }

    public synchronized void removeExpiredResponse(ServiceName serviceName, RequestHash requestHash) {
        Map<RequestHash, CachableResponse> responseMap = this.cache.get(serviceName);
        if (responseMap != null) {
            responseMap.remove(requestHash);
            if (responseMap.isEmpty()) {
                this.cache.remove(serviceName);
            }
        }
    }

    public CachableResponse getCachedResponse(ServiceName serviceName, RequestHash requestHash) {
        Map<RequestHash, CachableResponse> responseMap = this.cache.get(serviceName);
        if (responseMap != null) {
            return responseMap.get(requestHash);
        }
        return null;
    }

    public long getCacheSize(ServiceName serviceName) {
        Map<RequestHash, CachableResponse> responseMap = this.cache.get(serviceName);
        if (responseMap != null) {
            return responseMap.size();
        }
        return 0L;
    }

    public void cacheResponse(ServiceName serviceName, RequestHash requestHash, CachableResponse response) {
        Map<RequestHash, CachableResponse> responseMap = this.cache.get(serviceName);
        if (responseMap == null) {
            responseMap = new ConcurrentHashMap<RequestHash, CachableResponse>();
            this.cache.put(serviceName, responseMap);
        }
        responseMap.put(requestHash, response);
    }

    public void cacheResponse(ServiceName serviceName, RequestHash requestHash, CachableResponse response, CacheReplicationCommand cacheReplicationCommand) {
        this.cacheResponse(serviceName, requestHash, response);
        cacheReplicationCommand.addCachedReponse(serviceName, requestHash, response);
    }
}

