/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;

public class ClassEndpointFactory
extends EndpointFactory {
    private static ClassEndpointFactory instance = new ClassEndpointFactory();
    public static final QName CLASS_QNAME = new QName("http://ws.apache.org/ns/synapse", "class");
    public static final QName NAME_QNAME = new QName("name");
    public static final QName PARAMETER_QNAME = new QName("parameter");

    private ClassEndpointFactory() {
    }

    public static ClassEndpointFactory getInstance() {
        return instance;
    }

    @Override
    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement classElement = epConfig.getFirstChildWithName(CLASS_QNAME);
        if (classElement == null) {
            return null;
        }
        String nameAttr = classElement.getAttributeValue(NAME_QNAME);
        if (nameAttr == null) {
            return null;
        }
        Endpoint endpoint = null;
        try {
            Class<?> clazz = Class.forName(nameAttr);
            endpoint = (Endpoint)clazz.newInstance();
            Iterator iter = classElement.getChildrenWithName(PARAMETER_QNAME);
            while (iter.hasNext()) {
                OMElement paramEle = (OMElement)iter.next();
                this.setParameter(endpoint, paramEle);
            }
        }
        catch (Exception e) {
            ClassEndpointFactory.handleException("Cannot create class endpoint", e);
        }
        return endpoint;
    }

    private void setParameter(Endpoint endpoint, OMElement paramEle) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name = paramEle.getAttributeValue(new QName("name"));
        String value = paramEle.getText();
        PropertyHelper.setInstanceProperty((String)name, (Object)value, (Object)endpoint);
    }
}

