/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.hessian;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.format.hessian.HessianUtils;
import org.apache.synapse.util.SynapseBinaryDataSource;

public class HessianMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(HessianMessageFormatter.class);

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String encoding;
        String contentType = (String)msgCtxt.getProperty("ContentType");
        if (contentType == null) {
            contentType = "x-application/hessian";
        }
        if ((encoding = format.getCharSetEncoding()) != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public void writeTo(MessageContext msgCtx, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start writing the Hessian message to OutputStream");
        }
        if (msgCtx.getFLOW() == 4 || msgCtx.getEnvelope().hasFault()) {
            SOAPFault soapFault = msgCtx.getEnvelope().getBody().getFault();
            this.convertAndWriteHessianFault(soapFault, out);
        } else {
            this.writeHessianMessage(msgCtx, out);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Writing message as a Hessian message is successful");
        }
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        throw new AxisFault("Method not supported. Use the HessianMessageFormatter#writeTo method instead");
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        return URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHessianMessage(MessageContext msgCtxt, OutputStream out) throws AxisFault {
        OMElement omElement = msgCtxt.getEnvelope().getBody().getFirstElement();
        SynapseBinaryDataSource synapseBinaryDataSource = this.extractSynapseBinaryDataSource(omElement);
        if (synapseBinaryDataSource != null) {
            InputStream inputStream = null;
            try {
                inputStream = synapseBinaryDataSource.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
            catch (IOException e) {
                this.handleException("Couldn't get the bytes from the HessianDataSource", e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignore) {
                        log.warn((Object)"Error closing input stream.", (Throwable)ignore);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore) {
                        log.warn((Object)"Error closing output stream.", (Throwable)ignore);
                    }
                }
            }
        } else {
            this.handleException("Unable to find the Hessian content in the payload");
        }
    }

    private SynapseBinaryDataSource extractSynapseBinaryDataSource(OMElement omElement) {
        SynapseBinaryDataSource synapseBinaryDataSource = null;
        Iterator it = omElement.getChildren();
        while (it.hasNext() && synapseBinaryDataSource == null) {
            OMText tempNode;
            OMNode hessianElement = (OMNode)it.next();
            if (!(hessianElement instanceof OMText) || (tempNode = (OMText)hessianElement).getDataHandler() == null || !(((DataHandler)tempNode.getDataHandler()).getDataSource() instanceof SynapseBinaryDataSource)) continue;
            synapseBinaryDataSource = (SynapseBinaryDataSource)((DataHandler)tempNode.getDataHandler()).getDataSource();
        }
        return synapseBinaryDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertAndWriteHessianFault(SOAPFault soapFault, OutputStream out) throws AxisFault {
        BufferedOutputStream faultOutStream = new BufferedOutputStream(out);
        try {
            String hessianFaultCode = "500";
            String hessianFaultMessage = "";
            String hessianFaultDetail = "";
            if (soapFault.getCode() != null) {
                hessianFaultCode = soapFault.getCode().getText();
            }
            if (soapFault.getReason() != null) {
                hessianFaultMessage = soapFault.getReason().getText();
            }
            if (soapFault.getDetail() != null) {
                hessianFaultDetail = soapFault.getDetail().getText();
            }
            HessianUtils.writeFault(hessianFaultCode, hessianFaultMessage, hessianFaultDetail, faultOutStream);
            faultOutStream.flush();
        }
        catch (IOException e) {
            this.handleException("Unalbe to write the fault as a Hessian message", e);
        }
        finally {
            try {
                if (faultOutStream != null) {
                    faultOutStream.close();
                }
            }
            catch (IOException ignore) {
                log.warn((Object)"Error closing output stream.", (Throwable)ignore);
            }
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

