/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import com.oopsconsultancy.xmltask.XPathAnalyser;
import com.oopsconsultancy.xmltask.XPathAnalyserClient;
import com.oopsconsultancy.xmltask.XPathAnalyserFactory;
import com.oopsconsultancy.xmltask.ant.Param;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.w3c.dom.Node;

public class AnonymousCallAction
extends Action
implements XPathAnalyserClient {
    private final XmlTask task;
    private final String buffer;
    private final List params;
    private MacroDef macro;

    public AnonymousCallAction(MacroDef macro, XmlTask task, String buffer, List params) {
        this.macro = macro;
        this.task = task;
        this.buffer = buffer;
        this.params = params;
        this.init();
    }

    private void init() {
        Iterator it = this.params.iterator();
        while (it.hasNext()) {
            Param param = (Param)it.next();
            MacroDef.Attribute attribute = new MacroDef.Attribute();
            attribute.setName(param.getName());
            this.macro.addConfiguredAttribute(attribute);
        }
    }

    private void resetParams() {
        Iterator i = this.params.iterator();
        while (i.hasNext()) {
            Param param = (Param)i.next();
            if (param.getPath() == null) continue;
            param.setValue(null);
        }
    }

    public void applyNode(Node n, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, n.getNodeValue());
    }

    public void applyNode(String str, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, str);
    }

    public boolean apply(Node node) throws Exception {
        this.resetParams();
        this.log("Calling internal macro for " + node + (this.buffer != null ? " (in buffer " + this.buffer : ""), 3);
        if (this.buffer != null) {
            BufferStore.set(this.buffer, node, false, this.task);
        }
        MacroInstance instance = new MacroInstance();
        instance.setProject(this.task.getProject());
        instance.setOwningTarget(this.task.getOwningTarget());
        instance.setMacroDef(this.macro);
        if (this.params != null) {
            Iterator i = this.params.iterator();
            while (i.hasNext()) {
                Param param = (Param)i.next();
                if (param.getPath() != null) {
                    XPathAnalyser xpa = XPathAnalyserFactory.getAnalyser();
                    xpa.registerClient(this, param);
                    xpa.analyse(node, param.getPath());
                }
                instance.setDynamicAttribute(param.getName().toLowerCase(), param.getValue());
            }
        }
        instance.execute();
        return true;
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }
}

