/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import java.util.Collection;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.validator.EndpointDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.Validator;

public class ServiceDescriptionValidator
extends Validator {
    private ServiceDescription serviceDesc;
    private ServiceDescriptionJava serviceDescJava;
    private ServiceDescriptionWSDL serviceDescWSDL;

    public ServiceDescriptionValidator(ServiceDescription toValidate) {
        this.serviceDesc = toValidate;
        this.serviceDescJava = (ServiceDescriptionJava)((Object)this.serviceDesc);
        this.serviceDescWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDesc);
    }

    public boolean validate() {
        return this.validate(false);
    }

    public boolean validate(boolean performValidation) {
        if (this.getValidationLevel() == Validator.ValidationLevel.OFF) {
            return true;
        }
        return this.validateEndpointDescriptions(performValidation);
    }

    private boolean validateEndpointDescriptions(boolean performValidation) {
        boolean areAllValid = true;
        Collection<EndpointDescription> endpointDescs = this.serviceDesc.getEndpointDescriptions_AsCollection();
        for (EndpointDescription endpointDesc : endpointDescs) {
            EndpointDescriptionValidator endpointValidator = new EndpointDescriptionValidator(endpointDesc);
            boolean isEndpointValid = endpointValidator.validate(performValidation);
            if (isEndpointValid) continue;
            this.addValidationFailure(endpointValidator, "Endpoint failed validation");
            areAllValid = false;
        }
        return areAllValid;
    }
}

