/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;

public class AddressEndpointSerializer
extends DefaultEndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof AddressEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        AddressEndpoint addressEndpoint = (AddressEndpoint)endpoint;
        EndpointDefinition epAddress = addressEndpoint.getDefinition();
        OMElement addressElement = this.serializeEndpointDefinition(epAddress);
        endpointElement.addChild((OMNode)addressElement);
        this.serializeProperties(addressEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        return endpointElement;
    }

    @Override
    public OMElement serializeEndpointDefinition(EndpointDefinition endpointDefinition) {
        OMElement element = this.fac.createOMElement("address", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if (endpointDefinition.getAddress() != null) {
            element.addAttribute(this.fac.createOMAttribute("uri", null, endpointDefinition.getAddress()));
        } else {
            this.handleException("Invalid Endpoint. Address is required");
        }
        EndpointDefinitionSerializer serializer = new EndpointDefinitionSerializer();
        serializer.serializeEndpointDefinition(endpointDefinition, element);
        this.serializeSpecificEndpointProperties(endpointDefinition, element);
        return element;
    }
}

