/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.util.Arrays;
import org.apache.commons.digester3.ObjectCreateRule;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectCreateBuilder
extends AbstractBackToLinkedRuleBuilder<ObjectCreateRule> {
    private final ClassLoader classLoader;
    private Class<?> type;
    private String attributeName;
    private Class<?>[] constructorArgumentsType;
    private Object[] defaultConstructorArguments;

    ObjectCreateBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder, ClassLoader classLoader) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
        this.classLoader = classLoader;
    }

    public ObjectCreateBuilder ofType(String className) {
        if (className == null) {
            this.reportError("createObject().ofType( String )", "NULL Java type not allowed");
            return this;
        }
        try {
            return this.ofType(this.classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            this.reportError("createObject().ofType( String )", String.format("class '%s' cannot be load", className));
            return this;
        }
    }

    public <T> ObjectCreateBuilder ofType(Class<T> type) {
        if (type == null) {
            this.reportError("createObject().ofType( Class<?> )", "NULL Java type not allowed");
            return this;
        }
        this.type = type;
        return this;
    }

    public ObjectCreateBuilder ofTypeSpecifiedByAttribute(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public ObjectCreateBuilder usingConstructor(String ... paramTypeNames) {
        if (paramTypeNames == null) {
            this.reportError("createObject().usingConstructor( String[] )", "NULL parametersTypes not allowed");
            return this;
        }
        Class[] paramTypes = new Class[paramTypeNames.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            try {
                paramTypes[i] = this.classLoader.loadClass(paramTypeNames[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.reportError(String.format("createObject().usingConstructor( %s )", Arrays.toString(paramTypeNames)), String.format("class '%s' cannot be loaded", paramTypeNames[i]));
            }
        }
        return this.usingConstructor(paramTypes);
    }

    public ObjectCreateBuilder usingConstructor(Class<?> ... constructorArgumentTypes) {
        if (constructorArgumentTypes == null) {
            this.reportError("createObject().usingConstructor( Class<?>[] )", "NULL constructorArgumentTypes not allowed");
            return this;
        }
        this.constructorArgumentsType = constructorArgumentTypes;
        return this;
    }

    public ObjectCreateBuilder usingDefaultConstructorArguments(Object ... defaultConstructorArguments) {
        if (defaultConstructorArguments == null) {
            this.reportError("createObject().usingDefaultConstructorArguments( Object[] )", "NULL defaultConstructorArguments not allowed");
            return this;
        }
        this.defaultConstructorArguments = defaultConstructorArguments;
        return this;
    }

    @Override
    protected ObjectCreateRule createRule() {
        ObjectCreateRule objectCreateRule = new ObjectCreateRule(this.attributeName, this.type);
        if (this.constructorArgumentsType != null) {
            objectCreateRule.setConstructorArgumentTypes(this.constructorArgumentsType);
        }
        if (this.defaultConstructorArguments != null) {
            objectCreateRule.setDefaultConstructorArguments(this.defaultConstructorArguments);
        }
        return objectCreateRule;
    }
}

