/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.InvalidNameError;
import com.google.gxp.compiler.alerts.common.UnqualifiedNameError;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TemplateName
implements Serializable {
    private final String packageName;
    private final String baseName;
    private final boolean isValid;
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("\\p{Alpha}\\w*(?:\\.\\p{Alpha}\\w*)*");
    private static final Pattern BASE_NAME_PATTERN = Pattern.compile("\\p{Alpha}\\w*");
    private static final Pattern DOTTED_NAME_PATTERN = Pattern.compile("(.*)\\.([^\\.]*)", 32);
    private static final Pattern WHITESPACE_REMOVER_PATTERN = Pattern.compile("(\\s*)\\.(\\s*)");

    public static TemplateName create(String packageName, String baseName) {
        if (packageName == null) {
            return new Unqualified(baseName);
        }
        return new FullyQualified(packageName, baseName);
    }

    private TemplateName(String packageName, String baseName) {
        this.packageName = packageName;
        this.baseName = Preconditions.checkNotNull(baseName);
        this.isValid = TemplateName.isValidPackageName(packageName) && TemplateName.isValidBaseName(baseName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private static boolean isValidPackageName(String packageName) {
        return packageName == null || PACKAGE_NAME_PATTERN.matcher(packageName).matches();
    }

    public static boolean isValidBaseName(String baseName) {
        return BASE_NAME_PATTERN.matcher(baseName).matches();
    }

    public static TemplateName parseDottedName(AlertSink alertSink, SourcePosition sourcePosition, String dottedName) {
        String baseName;
        String packageName;
        Matcher matcher = DOTTED_NAME_PATTERN.matcher(dottedName = WHITESPACE_REMOVER_PATTERN.matcher(dottedName).replaceAll("."));
        if (matcher.matches()) {
            packageName = matcher.group(1);
            baseName = matcher.group(2);
        } else {
            packageName = null;
            baseName = dottedName;
        }
        if (!(TemplateName.isValidPackageName(packageName) && TemplateName.isValidBaseName(baseName) || alertSink == null)) {
            alertSink.add(new InvalidNameError(sourcePosition, dottedName));
        }
        return TemplateName.create(packageName, baseName);
    }

    public static FullyQualified parseFullyQualifiedDottedName(AlertSink alertSink, SourcePosition sourcePosition, String dottedName) {
        TemplateName result = TemplateName.parseDottedName(alertSink, sourcePosition, dottedName);
        if (result instanceof FullyQualified || result == null) {
            return (FullyQualified)result;
        }
        if (alertSink != null) {
            alertSink.add(new UnqualifiedNameError(sourcePosition, dottedName));
        }
        return null;
    }

    public static FullyQualified parseFullyQualifiedDottedName(String dottedName) {
        return TemplateName.parseFullyQualifiedDottedName(null, null, dottedName);
    }

    public abstract String toString();

    public boolean equals(Object that) {
        return this == that || that instanceof TemplateName && this.equals((TemplateName)that);
    }

    public boolean equals(TemplateName that) {
        return Objects.equal(this.packageName, that.packageName) && Objects.equal(this.baseName, that.baseName);
    }

    public int hashCode() {
        return Objects.hashCode(this.packageName, this.baseName);
    }

    private static final class Unqualified
    extends TemplateName {
        public Unqualified(String baseName) {
            super(null, baseName);
        }

        @Override
        public String toString() {
            return this.getBaseName();
        }
    }

    public static final class FullyQualified
    extends TemplateName {
        public FullyQualified(String packageName, String baseName) {
            super(Preconditions.checkNotNull(packageName), baseName);
        }

        @Override
        public String toString() {
            return this.getPackageName() + "." + this.getBaseName();
        }
    }
}

