/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.beanvalidation.validation.interceptor;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.beanvalidation.validation.interceptor.BeanValidationManager;

public class DefaultBeanValidationManager
implements BeanValidationManager {
    private static final Logger LOG = LogManager.getLogger(DefaultBeanValidationManager.class);
    protected Class providerClass;
    private ValidatorFactory validationFactory;

    @Inject
    public DefaultBeanValidationManager(@Inject(value="struts.beanValidation.providerClass", required=false) String providerClassName, @Inject(value="struts.beanValidation.ignoreXMLConfiguration", required=false) String ignoreXMLConfiguration, @Inject(required=true) ObjectFactory objectFactory) {
        Configuration configuration;
        LOG.info("Initializing bean validation factory to get a validator");
        if (StringUtils.isNotBlank((CharSequence)providerClassName)) {
            try {
                this.providerClass = objectFactory.getClassInstance(providerClassName);
                LOG.info("{} validator found", (Object)this.providerClass.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to find any bean validator implementation for class: {}", (Object)providerClassName);
                LOG.error("Unable to load bean validation provider class", (Throwable)e);
            }
        }
        if (this.providerClass == null) {
            LOG.warn("********** No bean validator class defined - Falling back to default provider **********");
        }
        Configuration configuration2 = configuration = this.providerClass != null ? Validation.byProvider((Class)this.providerClass).configure() : Validation.byDefaultProvider().configure();
        if (BooleanUtils.toBoolean((String)ignoreXMLConfiguration)) {
            configuration.ignoreXmlConfiguration();
            LOG.info("XML configurations will be ignored by Validator, to enable XML based validation, set struts.beanValidation.ignoreXMLConfiguration to false.");
        }
        if (configuration != null) {
            this.validationFactory = configuration.buildValidatorFactory();
        }
    }

    @Override
    public Validator getValidator() {
        return this.validationFactory.getValidator();
    }
}

