/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertPrincipalToLocal
implements IPrincipalToLocal {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertPrincipalToLocal.class);
    public static final String X509_CERT_PRINCIPAL_TO_LOCAL_REGEX = "x509.cert.principal.to.local.regex";
    private Pattern pattern;

    private static String extractCn(String subjectPrincipal) {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            List<Rdn> rdns = new LdapName(subjectPrincipal).getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rdn = rdns.get(i);
                if (!rdn.getType().equals("CN")) continue;
                return String.valueOf(rdn.getValue());
            }
            return null;
        }
        catch (InvalidNameException e) {
            throw new AccessControlException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
    }

    @Override
    public void prepare(Map<String, Object> conf) {
        if (conf.get(X509_CERT_PRINCIPAL_TO_LOCAL_REGEX) == null) {
            throw new IllegalStateException("x509.cert.principal.to.local.regex is not configured");
        }
        this.pattern = Pattern.compile(conf.get(X509_CERT_PRINCIPAL_TO_LOCAL_REGEX).toString());
    }

    @Override
    public String toLocal(String principalName) {
        Matcher roleMatcher = this.pattern.matcher(X509CertPrincipalToLocal.extractCn(principalName));
        if (roleMatcher.find()) {
            for (int i = 1; i <= roleMatcher.groupCount(); ++i) {
                if (roleMatcher.group(i) == null) continue;
                return roleMatcher.group(i);
            }
        }
        throw new AccessControlException("Invalid principal " + principalName);
    }
}

