/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.base.Splitter;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.storm.shade.org.apache.curator.utils.InternalACLProvider;
import org.apache.storm.shade.org.apache.curator.utils.PathUtils;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPaths {
    public static final String PATH_SEPARATOR = "/";
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final CreateMode NON_CONTAINER_MODE = CreateMode.PERSISTENT;
    static final int SEQUENTIAL_SUFFIX_DIGITS = 10;
    private static final Splitter PATH_SPLITTER = Splitter.on('/').omitEmptyStrings();

    public static CreateMode getContainerCreateMode() {
        return CreateModeHolder.containerCreateMode;
    }

    public static boolean hasContainerSupport() {
        return ZKPaths.getContainerCreateMode() != NON_CONTAINER_MODE;
    }

    public static String fixForNamespace(String namespace, String path) {
        return ZKPaths.fixForNamespace(namespace, path, false);
    }

    public static String fixForNamespace(String namespace, String path, boolean isSequential) {
        PathUtils.validatePath(path, isSequential);
        if (namespace != null) {
            return ZKPaths.makePath(namespace, path);
        }
        return path;
    }

    public static String getNodeFromPath(String path) {
        PathUtils.validatePath(path);
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        if (i + 1 >= path.length()) {
            return "";
        }
        return path.substring(i + 1);
    }

    public static PathAndNode getPathAndNode(String path) {
        PathUtils.validatePath(path);
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return new PathAndNode(path, "");
        }
        if (i + 1 >= path.length()) {
            return new PathAndNode(PATH_SEPARATOR, "");
        }
        String node = path.substring(i + 1);
        String parentPath = i > 0 ? path.substring(0, i) : PATH_SEPARATOR;
        return new PathAndNode(parentPath, node);
    }

    public static String extractSequentialSuffix(String path) {
        int length = path.length();
        return length > 10 ? path.substring(length - 10) : path;
    }

    public static List<String> split(String path) {
        PathUtils.validatePath(path);
        return PATH_SPLITTER.splitToList(path);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path, true, null, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path, boolean makeLastNode) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path, makeLastNode, null, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path, boolean makeLastNode, InternalACLProvider aclProvider) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path, makeLastNode, aclProvider, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path, boolean makeLastNode, InternalACLProvider aclProvider, boolean asContainers) throws InterruptedException, KeeperException {
        String subPath;
        PathUtils.validatePath(path);
        int pos = path.length();
        while (zookeeper.exists(subPath = path.substring(0, pos), false) == null && (pos = path.lastIndexOf(47, pos - 1)) > 0) {
        }
        while (pos < path.length()) {
            if ((pos = path.indexOf(47, pos + 1)) == -1) {
                if (!makeLastNode) break;
                pos = path.length();
            }
            subPath = path.substring(0, pos);
            try {
                List<ACL> acl = null;
                if (aclProvider != null && (acl = aclProvider.getAclForPath(subPath)) == null) {
                    acl = aclProvider.getDefaultAcl();
                }
                if (acl == null) {
                    acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
                }
                zookeeper.create(subPath, new byte[0], acl, ZKPaths.getCreateMode(asContainers));
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
    }

    public static void deleteChildren(ZooKeeper zookeeper, String path, boolean deleteSelf) throws InterruptedException, KeeperException {
        List<String> children;
        PathUtils.validatePath(path);
        try {
            children = zookeeper.getChildren(path, null);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        for (String child : children) {
            String fullPath = ZKPaths.makePath(path, child);
            ZKPaths.deleteChildren(zookeeper, fullPath, true);
        }
        if (deleteSelf) {
            try {
                zookeeper.delete(path, -1);
            }
            catch (KeeperException.NotEmptyException e) {
                ZKPaths.deleteChildren(zookeeper, path, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    public static List<String> getSortedChildren(ZooKeeper zookeeper, String path) throws InterruptedException, KeeperException {
        List<String> children = zookeeper.getChildren(path, false);
        ArrayList<String> sortedList = Lists.newArrayList(children);
        Collections.sort(sortedList);
        return sortedList;
    }

    public static String makePath(String parent, String child) {
        int maxPathLength = ZKPaths.nullableStringLength(parent) + ZKPaths.nullableStringLength(child) + 2;
        StringBuilder path = new StringBuilder(maxPathLength);
        ZKPaths.joinPath(path, parent, child);
        return path.toString();
    }

    public static String makePath(String parent, String firstChild, String ... restChildren) {
        int maxPathLength = ZKPaths.nullableStringLength(parent) + ZKPaths.nullableStringLength(firstChild) + 2;
        if (restChildren != null) {
            for (String child : restChildren) {
                maxPathLength += ZKPaths.nullableStringLength(child) + 1;
            }
        }
        StringBuilder path = new StringBuilder(maxPathLength);
        ZKPaths.joinPath(path, parent, firstChild);
        if (restChildren == null) {
            return path.toString();
        }
        for (String child : restChildren) {
            ZKPaths.joinPath(path, "", child);
        }
        return path.toString();
    }

    private static int nullableStringLength(String s) {
        return s != null ? s.length() : 0;
    }

    private static void joinPath(StringBuilder path, String parent, String child) {
        if (parent != null && parent.length() > 0) {
            if (parent.charAt(0) != '/') {
                path.append('/');
            }
            if (parent.charAt(parent.length() - 1) == '/') {
                path.append(parent, 0, parent.length() - 1);
            } else {
                path.append(parent);
            }
        }
        if (child == null || child.length() == 0 || child.length() == 1 && child.charAt(0) == '/') {
            if (path.length() == 0) {
                path.append('/');
            }
            return;
        }
        path.append('/');
        int childAppendBeginIndex = child.charAt(0) == '/' ? 1 : 0;
        int childAppendEndIndex = child.charAt(child.length() - 1) == '/' ? child.length() - 1 : child.length();
        path.append(child, childAppendBeginIndex, childAppendEndIndex);
    }

    private ZKPaths() {
    }

    private static CreateMode getCreateMode(boolean asContainers) {
        return asContainers ? ZKPaths.getContainerCreateMode() : CreateMode.PERSISTENT;
    }

    public static class PathAndNode {
        private final String path;
        private final String node;

        public PathAndNode(String path, String node) {
            this.path = path;
            this.node = node;
        }

        public String getPath() {
            return this.path;
        }

        public String getNode() {
            return this.node;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.node.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathAndNode other = (PathAndNode)obj;
            if (!this.node.equals(other.node)) {
                return false;
            }
            return this.path.equals(other.path);
        }

        public String toString() {
            return "PathAndNode [path=" + this.path + ", node=" + this.node + "]";
        }
    }

    private static class CreateModeHolder {
        private static final Logger log;
        private static final CreateMode containerCreateMode;

        private CreateModeHolder() {
        }

        static {
            CreateMode localCreateMode;
            log = LoggerFactory.getLogger(ZKPaths.class);
            try {
                localCreateMode = CreateMode.valueOf("CONTAINER");
            }
            catch (IllegalArgumentException ignore) {
                localCreateMode = NON_CONTAINER_MODE;
                log.warn("The version of ZooKeeper being used doesn't support Container nodes. CreateMode.PERSISTENT will be used instead.");
            }
            containerCreateMode = localCreateMode;
        }
    }
}

