/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;

public class ClusterStateContext {
    private final Map<String, Object> conf;
    private DaemonType daemonType;

    public ClusterStateContext() {
        this.daemonType = DaemonType.UNKNOWN;
        this.conf = new HashMap<String, Object>();
    }

    public ClusterStateContext(DaemonType daemonType, Map<String, Object> conf) {
        this.daemonType = daemonType;
        this.conf = conf;
    }

    public DaemonType getDaemonType() {
        return this.daemonType;
    }

    public List<ACL> getDefaultZkAcls() {
        return this.daemonType.getDefaultZkAcls(this.conf);
    }

    public List<ACL> getZkSecretAcls(WorkerTokenServiceType type) {
        return this.daemonType.getZkSecretAcls(type, this.conf);
    }
}

