/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.handler.codec.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.storm.shade.io.netty.handler.codec.mqtt.MqttReasonCodes;
import org.apache.storm.shade.io.netty.util.internal.ObjectUtil;
import org.apache.storm.shade.io.netty.util.internal.StringUtil;

public final class MqttUnsubAckPayload {
    private final List<MqttReasonCodes.UnsubAck> unsubscribeReasonCodes;
    private static final MqttUnsubAckPayload EMPTY = new MqttUnsubAckPayload(new short[0]);

    public static MqttUnsubAckPayload withEmptyDefaults(MqttUnsubAckPayload payload) {
        if (payload == null) {
            return EMPTY;
        }
        return payload;
    }

    public MqttUnsubAckPayload(short ... unsubscribeReasonCodes) {
        ObjectUtil.checkNotNull(unsubscribeReasonCodes, "unsubscribeReasonCodes");
        ArrayList<MqttReasonCodes.UnsubAck> list = new ArrayList<MqttReasonCodes.UnsubAck>(unsubscribeReasonCodes.length);
        short[] sArray = unsubscribeReasonCodes;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short v = sArray[i];
            list.add(MqttReasonCodes.UnsubAck.valueOf((byte)(v & 0xFF)));
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list);
    }

    public MqttUnsubAckPayload(Iterable<Short> unsubscribeReasonCodes) {
        ObjectUtil.checkNotNull(unsubscribeReasonCodes, "unsubscribeReasonCodes");
        ArrayList<MqttReasonCodes.UnsubAck> list = new ArrayList<MqttReasonCodes.UnsubAck>();
        for (Short v : unsubscribeReasonCodes) {
            ObjectUtil.checkNotNull(v, "unsubscribeReasonCode");
            list.add(MqttReasonCodes.UnsubAck.valueOf(v.byteValue()));
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list);
    }

    public List<Short> unsubscribeReasonCodes() {
        return this.typedReasonCodesToOrdinal();
    }

    private List<Short> typedReasonCodesToOrdinal() {
        ArrayList<Short> codes = new ArrayList<Short>(this.unsubscribeReasonCodes.size());
        for (MqttReasonCodes.UnsubAck code : this.unsubscribeReasonCodes) {
            codes.add((short)(code.byteValue() & 0xFF));
        }
        return codes;
    }

    public List<MqttReasonCodes.UnsubAck> typedReasonCodes() {
        return this.unsubscribeReasonCodes;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "unsubscribeReasonCodes=" + this.unsubscribeReasonCodes + ']';
    }
}

