/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import org.apache.storm.scheduler.ISupervisor;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.Utils;

public class StandaloneSupervisor
implements ISupervisor {
    private String supervisorId;
    private Map<String, Object> conf;

    @Override
    public void prepare(Map<String, Object> topoConf, String schedulerLocalDir) {
        try {
            LocalState localState = new LocalState(schedulerLocalDir, true);
            String supervisorId = localState.getSupervisorId();
            if (supervisorId == null) {
                supervisorId = this.generateSupervisorId();
                localState.setSupervisorId(supervisorId);
            }
            this.conf = topoConf;
            this.supervisorId = supervisorId;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @Override
    public String getAssignmentId() {
        return this.supervisorId;
    }

    @Override
    public Object getMetadata() {
        Object ports = this.conf.get("supervisor.slots.ports");
        return ports;
    }

    @Override
    public boolean confirmAssigned(int port) {
        return true;
    }

    @Override
    public void killedWorker(int port) {
    }

    @Override
    public void assigned(Collection<Integer> ports) {
    }

    public String generateSupervisorId() {
        Object extraPart = "";
        try {
            extraPart = "-" + InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Utils.uuid() + (String)extraPart;
    }
}

