/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc;

import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.utils.Time;

public abstract class OutstandingRequest {
    private final long start = Time.currentTimeMillis();
    private final String function;
    private final DRPCRequest req;
    private volatile boolean fetched = false;

    public OutstandingRequest(String function, DRPCRequest req) {
        this.function = function;
        this.req = req;
    }

    public DRPCRequest getRequest() {
        return this.req;
    }

    public void fetched() {
        this.fetched = true;
    }

    public boolean wasFetched() {
        return this.fetched;
    }

    public String getFunction() {
        return this.function;
    }

    public boolean isTimedOut(long timeoutMs) {
        return this.start + timeoutMs <= Time.currentTimeMillis();
    }

    public abstract void returnResult(String var1);

    public abstract void fail(DRPCExecutionException var1);
}

