/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;

class MockConfiguration
implements Configuration {
    private final String pid;
    private final String factoryPid;
    private Dictionary<String, Object> props;
    private static final String[] AUTO_PROPS = new String[]{"service.pid", "service.factoryPid", "service.bundleLocation"};

    public MockConfiguration(String pid) {
        this.pid = pid;
        this.factoryPid = null;
    }

    public MockConfiguration(String pid, String factoryPid) {
        this.pid = pid;
        this.factoryPid = factoryPid;
    }

    public String getPid() {
        return this.pid;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public Dictionary<String, Object> getProperties() {
        if (this.props == null) {
            return null;
        }
        return new Hashtable<String, Object>(MapUtil.toMap(this.props));
    }

    public void update() {
        this.props = MockConfiguration.newConfig(this.pid, this.factoryPid);
    }

    public void update(Dictionary<String, ?> properties) {
        this.props = new Hashtable(MapUtil.toMap(properties));
        this.props.put("service.pid", this.pid);
        if (this.factoryPid != null) {
            this.props.put("service.factoryPid", this.factoryPid);
        }
    }

    public boolean updateIfDifferent(Dictionary<String, ?> properties) throws IOException {
        if (!MockConfiguration.equals(properties, this.props)) {
            this.update(properties);
            return true;
        }
        return false;
    }

    public void delete() {
        this.props = null;
    }

    public String toString() {
        return this.props.toString();
    }

    private static Dictionary<String, Object> newConfig(String pid, String factoryPid) {
        Dictionary<String, Object> config = MapUtil.toDictionary("service.pid", pid);
        if (factoryPid != null) {
            config.put("service.factoryPid", factoryPid);
        }
        return config;
    }

    public void setBundleLocation(String bundleLocation) {
        throw new UnsupportedOperationException();
    }

    public String getBundleLocation() {
        throw new UnsupportedOperationException();
    }

    public long getChangeCount() {
        throw new UnsupportedOperationException();
    }

    public Dictionary<String, Object> getProcessedProperties(ServiceReference<?> reference) {
        throw new UnsupportedOperationException();
    }

    public void addAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<Configuration.ConfigurationAttribute> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public void removeAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    static boolean equals(Dictionary<String, Object> props1, Dictionary<String, Object> props2) {
        int count2;
        if (props1 == null) {
            return props2 == null;
        }
        if (props2 == null) {
            return false;
        }
        int count1 = MockConfiguration.getCount(props1);
        if (count1 != (count2 = MockConfiguration.getCount(props2))) {
            return false;
        }
        Enumeration<String> keys = props1.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (MockConfiguration.isAutoProp(key)) continue;
            Object val1 = props1.get(key);
            Object val2 = props2.get(key);
            if (val1 == null) {
                if (val2 == null) continue;
                return false;
            }
            if (val2 == null) {
                return false;
            }
            if (val1.getClass().isArray()) {
                Object[] a2;
                if (!val2.getClass().isArray()) {
                    return false;
                }
                Object[] a1 = MockConfiguration.convertToObjectArray(val1);
                if (Arrays.equals(a1, a2 = MockConfiguration.convertToObjectArray(val2))) continue;
                return false;
            }
            if (val1.equals(val2)) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertToObjectArray(Object value) {
        Object[] values;
        if (value instanceof long[]) {
            long[] a = (long[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof int[]) {
            int[] a = (int[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof double[]) {
            double[] a = (double[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof byte[]) {
            byte[] a = (byte[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof float[]) {
            float[] a = (float[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = Float.valueOf(a[i]);
            }
        } else if (value instanceof short[]) {
            short[] a = (short[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof boolean[]) {
            boolean[] a = (boolean[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof char[]) {
            char[] a = (char[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = Character.valueOf(a[i]);
            }
        } else {
            values = (Object[])value;
        }
        return values;
    }

    static boolean isAutoProp(String name) {
        for (String p : AUTO_PROPS) {
            if (!p.equals(name)) continue;
            return true;
        }
        return false;
    }

    static int getCount(Dictionary<String, Object> props) {
        int count;
        int n = count = props == null ? 0 : props.size();
        if (props != null) {
            for (String p : AUTO_PROPS) {
                if (props.get(p) == null) continue;
                --count;
            }
        }
        return count;
    }
}

