/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testbundle.models.implextend.ImplementsInterfacePropertyModel;
import org.apache.sling.models.it.testbundle.models.implextend.ImplementsInterfacePropertyModel2;
import org.apache.sling.models.it.testbundle.models.implextend.InvalidSampleServiceInterface;
import org.apache.sling.models.it.testbundle.models.implextend.SampleServiceInterface;
import org.apache.sling.models.it.testbundle.models.implextend.SimplePropertyModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ImplementsExtendsIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private AdapterManager adapterManager;
    private String firstValue;
    private String secondValue;
    private String thirdValue;
    private ResourceResolver resolver;
    private Resource resource;
    private Node createdNode;

    @Before
    public void setUp() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.adapterManager = (AdapterManager)this.teleporter.getService(AdapterManager.class);
        this.firstValue = RandomStringUtils.secure().nextAlphanumeric(10);
        this.thirdValue = RandomStringUtils.secure().nextAlphanumeric(10);
        this.resolver = rrFactory.getServiceResourceResolver(null);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node rootNode = session.getRootNode();
        this.createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        this.createdNode.setProperty("first", this.firstValue);
        this.createdNode.setProperty("third", this.thirdValue);
        session.save();
        this.resource = this.resolver.getResource(this.createdNode.getPath());
    }

    @After
    public void after() {
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    @Test
    public void testImplementsInterfaceModel() {
        SampleServiceInterface model = (SampleServiceInterface)this.adapterManager.getAdapter((Object)this.resource, SampleServiceInterface.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(ImplementsInterfacePropertyModel.class, model.getClass());
        Assert.assertEquals((Object)(this.firstValue + "|" + this.secondValue + "|" + this.thirdValue), (Object)model.getAllProperties());
    }

    @Test
    public void testImplementsInterfaceModel_ImplClassImplicitlyMapped() {
        ImplementsInterfacePropertyModel model = (ImplementsInterfacePropertyModel)this.adapterManager.getAdapter((Object)this.resource, ImplementsInterfacePropertyModel.class);
        Assert.assertNotNull((Object)model);
    }

    @Test
    public void testInvalidImplementsInterfaceModel() {
        InvalidSampleServiceInterface model = (InvalidSampleServiceInterface)this.adapterManager.getAdapter((Object)this.resource, InvalidSampleServiceInterface.class);
        Assert.assertNull((Object)model);
    }

    @Test
    public void testExtendsClassModel() {
        SimplePropertyModel model = (SimplePropertyModel)this.adapterManager.getAdapter((Object)this.resource, SimplePropertyModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)("!" + this.firstValue + "|" + this.secondValue + "|" + this.thirdValue + "!"), (Object)model.getAllProperties());
    }

    @Test
    public void testImplementsInterfaceModelWithPickLastImplementationPicker() throws RepositoryException {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node node = (Node)this.resource.adaptTo(Node.class);
        Node childNode = node.addNode("custom");
        childNode.setProperty("first", this.firstValue);
        childNode.setProperty("third", this.thirdValue);
        session.save();
        Resource childResource = this.resolver.getResource(childNode.getPath());
        SampleServiceInterface model = (SampleServiceInterface)this.adapterManager.getAdapter((Object)childResource, SampleServiceInterface.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(ImplementsInterfacePropertyModel2.class, model.getClass());
        Assert.assertEquals((Object)(this.firstValue + "|" + this.secondValue + "|" + this.thirdValue), (Object)model.getAllProperties());
        childNode.remove();
        session.save();
    }
}

