/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.AnnotatedElement;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class SlingObjectInjectorRequestTest {
    private final SlingObjectInjector injector = new SlingObjectInjector();
    @Mock
    private AnnotatedElement annotatedElement;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private SlingJakartaHttpServletResponse response;
    @Mock
    private SlingScriptHelper scriptHelper;
    @Mock
    private ResourceResolver resourceResolver;
    @Mock
    private Resource resource;
    @Mock
    private DisposalCallbackRegistry registry;

    SlingObjectInjectorRequestTest() {
    }

    @BeforeEach
    void setUp() {
        SlingBindings bindings = new SlingBindings();
        bindings.put("sling", (Object)this.scriptHelper);
        Mockito.lenient().when((Object)this.request.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.lenient().when((Object)this.request.getResource()).thenReturn((Object)this.resource);
        Mockito.lenient().when(this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        Mockito.lenient().when((Object)this.scriptHelper.getResponse()).thenReturn((Object)JakartaToJavaxResponseWrapper.toJavaxResponse((SlingJakartaHttpServletResponse)this.response));
        Mockito.lenient().when((Object)this.scriptHelper.getJakartaResponse()).thenReturn((Object)this.response);
    }

    @Test
    void testResourceResolver() {
        Object result = this.injector.getValue((Object)this.request, null, ResourceResolver.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.resourceResolver, (Object)result);
    }

    @Test
    void testResource() {
        Object result = this.injector.getValue((Object)this.request, null, Resource.class, this.annotatedElement, this.registry);
        Assertions.assertNull((Object)result);
        Mockito.when((Object)this.annotatedElement.isAnnotationPresent(SlingObject.class)).thenReturn((Object)true);
        result = this.injector.getValue((Object)this.request, null, Resource.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.resource, (Object)result);
    }

    @Test
    void testJakartaRequest() {
        Object result = this.injector.getValue((Object)this.request, null, SlingJakartaHttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.request, (Object)result);
        result = this.injector.getValue((Object)this.request, null, HttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.request, (Object)result);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testJavaxResponse() {
        Object result = this.injector.getValue((Object)this.request, null, SlingHttpServletResponse.class, this.annotatedElement, this.registry);
        Assertions.assertTrue((boolean)(result instanceof HttpServletResponseWrapper));
        Assertions.assertSame((Object)this.response, (Object)((HttpServletResponseWrapper)result).getResponse());
        result = this.injector.getValue((Object)this.request, null, HttpServletResponse.class, this.annotatedElement, this.registry);
        Assertions.assertTrue((boolean)(result instanceof HttpServletResponseWrapper));
        Assertions.assertSame((Object)this.response, (Object)((HttpServletResponseWrapper)result).getResponse());
    }

    @Deprecated(since="2.0.0")
    @Test
    void testJavaxRequest() {
        Object result = this.injector.getValue((Object)this.request, null, SlingHttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertTrue((boolean)(result instanceof HttpServletRequestWrapper));
        Assertions.assertSame((Object)this.request, (Object)((HttpServletRequestWrapper)result).getRequest());
        result = this.injector.getValue((Object)this.request, null, javax.servlet.http.HttpServletRequest.class, this.annotatedElement, this.registry);
        Assertions.assertTrue((boolean)(result instanceof HttpServletRequestWrapper));
        Assertions.assertSame((Object)this.request, (Object)((HttpServletRequestWrapper)result).getRequest());
    }

    @Test
    void testJakartaResponse() {
        Object result = this.injector.getValue((Object)this.request, null, SlingJakartaHttpServletResponse.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.response, (Object)result);
        result = this.injector.getValue((Object)this.request, null, jakarta.servlet.http.HttpServletResponse.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.response, (Object)result);
    }

    @Test
    void testScriptHelper() {
        Object result = this.injector.getValue((Object)this.request, null, SlingScriptHelper.class, this.annotatedElement, this.registry);
        Assertions.assertSame((Object)this.scriptHelper, (Object)result);
    }

    @Test
    void testInvalid() {
        Object result = this.injector.getValue((Object)this, null, SlingScriptHelper.class, this.annotatedElement, this.registry);
        Assertions.assertNull((Object)result);
    }
}

