/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.factory.MissingElementException;
import org.apache.sling.models.factory.MissingElementsException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.ArrayPrimitivesModel;
import org.apache.sling.models.testmodels.classes.ArrayWrappersModel;
import org.apache.sling.models.testmodels.classes.ChildModel;
import org.apache.sling.models.testmodels.classes.ChildResourceModel;
import org.apache.sling.models.testmodels.classes.ChildValueMapModel;
import org.apache.sling.models.testmodels.classes.CollectionDefaultsModel;
import org.apache.sling.models.testmodels.classes.ListDefaultsModel;
import org.apache.sling.models.testmodels.classes.ListModel;
import org.apache.sling.models.testmodels.classes.ParentModel;
import org.apache.sling.models.testmodels.classes.ResourceModelWithRequiredField;
import org.apache.sling.models.testmodels.classes.ResourceModelWithRequiredFieldOptionalStrategy;
import org.apache.sling.models.testmodels.classes.SimplePropertyModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class ResourceModelClassesTest {
    private ModelAdapterFactory factory;

    ResourceModelClassesTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        ValueMapInjector valueMapInjector = new ValueMapInjector();
        this.factory.injectors = Arrays.asList(new ChildResourceInjector(), valueMapInjector);
        this.factory.injectAnnotationProcessorFactories = this.factory.injectAnnotationProcessorFactories = Collections.singletonList(new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SimplePropertyModel.class, ArrayWrappersModel.class, ResourceModelWithRequiredField.class, ChildValueMapModel.class, ArrayPrimitivesModel.class, ChildResourceModel.class, ResourceModelWithRequiredFieldOptionalStrategy.class, ParentModel.class, ChildModel.class, ListModel.class, ListDefaultsModel.class, CollectionDefaultsModel.class});
    }

    @Test
    void testSimplePropertyModel() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        map.put("intProperty", 3);
        map.put("arrayProperty", new String[]{"three", "four"});
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        SimplePropertyModel model = (SimplePropertyModel)this.factory.getAdapter((Object)res, SimplePropertyModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assertions.assertNull((Object)model.getSecond());
        Assertions.assertEquals((Object)"third-value", (Object)model.getThirdProperty());
        Assertions.assertEquals((int)3, (int)model.getIntProperty());
        String[] array = model.getArrayProperty();
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)"three", (Object)array[0]);
        Assertions.assertTrue((boolean)model.isPostConstructCalled());
        ((Resource)Mockito.verify((Object)res, (VerificationMode)Mockito.times((int)1))).adaptTo(ValueMap.class);
    }

    @Test
    void testArrayPrimitivesModel() {
        HashMap<String, Integer[]> map = new HashMap<String, Integer[]>();
        map.put("intArray", new int[]{1, 2, 9, 8});
        map.put("secondIntArray", new Integer[]{1, 2, 9, 8});
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ArrayPrimitivesModel model = (ArrayPrimitivesModel)this.factory.getAdapter((Object)res, ArrayPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        int[] primitiveIntArray = model.getIntArray();
        Assertions.assertEquals((int)4, (int)primitiveIntArray.length);
        Assertions.assertEquals((int)2, (int)primitiveIntArray[1]);
        int[] secondPrimitiveIntArray = model.getSecondIntArray();
        Assertions.assertEquals((int)4, (int)secondPrimitiveIntArray.length);
        Assertions.assertEquals((int)2, (int)secondPrimitiveIntArray[1]);
    }

    @Test
    void testArrayWrappersModel() {
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("intArray", new Integer[]{1, 2, 9, 8});
        map.put("secondIntArray", new int[]{1, 2, 9, 8});
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ArrayWrappersModel model = (ArrayWrappersModel)this.factory.getAdapter((Object)res, ArrayWrappersModel.class);
        Assertions.assertNotNull((Object)model);
        Integer[] intArray = model.getIntArray();
        Assertions.assertEquals((int)4, (int)intArray.length);
        Assertions.assertEquals((Integer)2, (Integer)intArray[1]);
        Integer[] secondIntArray = model.getSecondIntArray();
        Assertions.assertEquals((int)4, (int)secondIntArray.length);
        Assertions.assertEquals((Integer)2, (Integer)secondIntArray[1]);
    }

    @Test
    void testListModel() {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("intList", new Integer[]{1, 2, 9, 8});
        map.put("stringList", new String[]{"hello", "world"});
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ListModel model = (ListModel)this.factory.getAdapter((Object)res, ListModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)4, (int)model.getIntList().size());
        Assertions.assertEquals((Integer)2, (Integer)model.getIntList().get(1));
        Assertions.assertEquals((int)2, (int)model.getStringList().size());
        Assertions.assertEquals((Object)"hello", (Object)model.getStringList().get(0));
        Assertions.assertNull(model.getEmptyStringList());
    }

    @Test
    void testListDefaultsModel() {
        HashMap map = new HashMap();
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ListDefaultsModel model = (ListDefaultsModel)this.factory.getAdapter((Object)res, ListDefaultsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(Arrays.asList("v1", "v2"), model.getStringList());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), model.getIntList());
        Assertions.assertEquals(Arrays.asList(1L, 2L), model.getLongList());
        Assertions.assertEquals(Arrays.asList(true, false), model.getBooleanList());
        Assertions.assertEquals(Arrays.asList((short)1), model.getShortList());
        Assertions.assertEquals(Arrays.asList(Float.valueOf(1.1f), Float.valueOf(1.2f)), model.getFloatList());
        Assertions.assertEquals(Arrays.asList(1.1, 1.2, 1.3), model.getDoubleList());
    }

    @Test
    void testCollectionDefaultsModel() {
        HashMap map = new HashMap();
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        CollectionDefaultsModel model = (CollectionDefaultsModel)this.factory.getAdapter((Object)res, CollectionDefaultsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(Arrays.asList(1, 2, 3), model.getIntCollection());
        Assertions.assertEquals(Arrays.asList("v1", "v2"), model.getStringCollection());
    }

    @Test
    void testRequiredPropertyModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        ValueMap vm = (ValueMap)Mockito.spy((Object)new ValueMapDecorator(map));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ResourceModelWithRequiredField model = (ResourceModelWithRequiredField)this.factory.getAdapter((Object)res, ResourceModelWithRequiredField.class);
        Assertions.assertNull((Object)model);
        ((ValueMap)Mockito.verify((Object)vm)).get("required", String.class);
    }

    @Test
    void testRequiredPropertyModelWithException() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        ValueMap vm = (ValueMap)Mockito.spy((Object)new ValueMapDecorator(map));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        boolean thrown = false;
        try {
            this.factory.createModel((Object)res, ResourceModelWithRequiredField.class);
        }
        catch (MissingElementsException e) {
            Assertions.assertEquals((Object)"required", (Object)((Field)((MissingElementException)e.getMissingElements().iterator().next()).getElement()).getName());
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown);
        ((ValueMap)Mockito.verify((Object)vm)).get("required", String.class);
    }

    @Test
    void testRequiredPropertyMissingModelOptionalStrategy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        ValueMap vm = (ValueMap)Mockito.spy((Object)new ValueMapDecorator(map));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ResourceModelWithRequiredFieldOptionalStrategy model = (ResourceModelWithRequiredFieldOptionalStrategy)this.factory.getAdapter((Object)res, ResourceModelWithRequiredFieldOptionalStrategy.class);
        Assertions.assertNull((Object)model);
        ((ValueMap)Mockito.verify((Object)vm)).get("optional1", String.class);
        ((ValueMap)Mockito.verify((Object)vm)).get("required1", String.class);
    }

    @Test
    void testRequiredPropertyModelOptionalStrategy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("required1", "required value");
        map.put("required2", "required value");
        map.put("required3", "required value");
        ValueMap vm = (ValueMap)Mockito.spy((Object)new ValueMapDecorator(map));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ResourceModelWithRequiredFieldOptionalStrategy model = (ResourceModelWithRequiredFieldOptionalStrategy)this.factory.getAdapter((Object)res, ResourceModelWithRequiredFieldOptionalStrategy.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"required value", (Object)model.getRequired1());
        Assertions.assertEquals((Object)"required value", (Object)model.getRequired2());
        ((ValueMap)Mockito.verify((Object)vm)).get("optional1", String.class);
        ((ValueMap)Mockito.verify((Object)vm)).get("required1", String.class);
    }

    @Test
    void testChildResource() {
        Resource child = (Resource)Mockito.mock(Resource.class);
        Resource secondChild = (Resource)Mockito.mock(Resource.class);
        Resource emptyChild = (Resource)Mockito.mock(Resource.class);
        Resource firstGrandChild = (Resource)Mockito.mock(Resource.class);
        Resource secondGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)secondChild.listChildren()).thenReturn(Arrays.asList(firstGrandChild, secondGrandChild).iterator());
        Mockito.when((Object)emptyChild.listChildren()).thenReturn(Collections.emptySet().iterator());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("firstChild")).thenReturn((Object)child);
        Mockito.when((Object)res.getChild("secondChild")).thenReturn((Object)secondChild);
        Mockito.when((Object)res.getChild("emptyChild")).thenReturn((Object)emptyChild);
        ChildResourceModel model = (ChildResourceModel)this.factory.getAdapter((Object)res, ChildResourceModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)child, (Object)model.getFirstChild());
        Assertions.assertEquals((int)2, (int)model.getGrandChildren().size());
        Assertions.assertEquals((Object)firstGrandChild, (Object)model.getGrandChildren().get(0));
        Assertions.assertEquals((Object)secondGrandChild, (Object)model.getGrandChildren().get(1));
        Assertions.assertEquals((int)0, (int)model.getEmptyGrandChildren().size());
    }

    @Test
    void testChildValueMap() {
        ValueMap map = ValueMapDecorator.EMPTY;
        Resource child = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)child.adaptTo(ValueMap.class))).thenReturn((Object)map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("firstChild")).thenReturn((Object)child);
        ChildValueMapModel model = (ChildValueMapModel)this.factory.getAdapter((Object)res, ChildValueMapModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)map, (Object)model.getFirstChild());
    }

    @Test
    void testChildModel() {
        String firstValue = RandomStringUtils.randomAlphabetic((int)10);
        ValueMapDecorator firstMap = new ValueMapDecorator(Collections.singletonMap("property", firstValue));
        Resource firstChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstChild.adaptTo(ValueMap.class))).thenReturn((Object)firstMap);
        Mockito.lenient().when((Object)((ChildModel)firstChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        String firstGrandChildValue = RandomStringUtils.randomAlphabetic((int)10);
        ValueMapDecorator firstGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", firstGrandChildValue));
        String secondGrandChildValue = RandomStringUtils.randomAlphabetic((int)10);
        ValueMapDecorator secondGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", secondGrandChildValue));
        Resource firstGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)firstGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)firstGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)secondGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)secondGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)secondGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)secondChild.listChildren()).thenReturn(Arrays.asList(firstGrandChild, secondGrandChild).iterator());
        Resource emptyChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)emptyChild.listChildren()).thenReturn(Collections.emptySet().iterator());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)res.getChild("firstChild")).thenReturn((Object)firstChild);
        Mockito.lenient().when((Object)res.getChild("secondChild")).thenReturn((Object)secondChild);
        Mockito.lenient().when((Object)res.getChild("emptyChild")).thenReturn((Object)emptyChild);
        ParentModel model = (ParentModel)this.factory.getAdapter((Object)res, ParentModel.class);
        Assertions.assertNotNull((Object)model);
        ChildModel childModel = model.getFirstChild();
        Assertions.assertNotNull((Object)childModel);
        Assertions.assertEquals((Object)firstValue, (Object)childModel.getProperty());
        Assertions.assertEquals((int)2, (int)model.getGrandChildren().size());
        Assertions.assertEquals((Object)firstGrandChildValue, (Object)model.getGrandChildren().get(0).getProperty());
        Assertions.assertEquals((Object)secondGrandChildValue, (Object)model.getGrandChildren().get(1).getProperty());
        Assertions.assertEquals((int)0, (int)model.getEmptyGrandChildren().size());
    }

    private class AdaptToChildModel
    implements Answer<ChildModel> {
        private AdaptToChildModel() {
        }

        public ChildModel answer(InvocationOnMock invocation) throws Throwable {
            return (ChildModel)ResourceModelClassesTest.this.factory.getAdapter(invocation.getMock(), ChildModel.class);
        }
    }
}

