/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.AdapterImplementationsTest;
import org.apache.sling.models.impl.FirstImplementationPicker;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.testmodels.classes.implextend.EvenSimplerPropertyModel;
import org.apache.sling.models.testmodels.classes.implextend.ExtendsClassPropertyModel;
import org.apache.sling.models.testmodels.classes.implextend.ImplementsInterfacePropertyModel;
import org.apache.sling.models.testmodels.classes.implextend.ImplementsInterfacePropertyModel2;
import org.apache.sling.models.testmodels.classes.implextend.InvalidImplementsInterfacePropertyModel;
import org.apache.sling.models.testmodels.classes.implextend.InvalidSampleServiceInterface;
import org.apache.sling.models.testmodels.classes.implextend.SampleServiceInterface;
import org.apache.sling.models.testmodels.classes.implextend.SimplePropertyModel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@ExtendWith(value={MockitoExtension.class})
class ImplementsExtendsTest {
    @Mock
    private BundleContext bundleContext;
    @Mock
    private Bundle bundle;
    @Mock
    private BundleEvent bundleEvent;
    private ModelAdapterFactory factory;
    private ServiceRegistration<AdapterFactory>[] registeredAdapterFactories;
    private ImplementationPicker firstImplementationPicker = new FirstImplementationPicker();

    ImplementsExtendsTest() {
    }

    @BeforeEach
    void setup() throws ClassNotFoundException, MalformedURLException {
        Mockito.lenient().when((Object)this.bundleContext.registerService(ArgumentMatchers.anyString(), ArgumentMatchers.any(), (Dictionary)ArgumentMatchers.any(Dictionary.class))).then(new Answer<ServiceRegistration<?>>(){

            public ServiceRegistration<?> answer(InvocationOnMock invocation) throws Throwable {
                final Dictionary props = (Dictionary)invocation.getArguments()[2];
                ServiceRegistration reg = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
                ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
                ((ServiceRegistration)Mockito.lenient().doReturn((Object)ref).when((Object)reg)).getReference();
                Mockito.lenient().when(ref.getProperty(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

                    public Object answer(InvocationOnMock invocation) throws Throwable {
                        String key = (String)invocation.getArguments()[0];
                        return props.get(key);
                    }
                });
                return reg;
            }
        });
        this.factory = AdapterFactoryTest.createModelAdapterFactory(this.bundleContext);
        this.factory.injectors = Collections.singletonList(new ValueMapInjector());
        this.factory.implementationPickers = Collections.singletonList(this.firstImplementationPicker);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("Sling-Model-Packages", "org.apache.sling.models.testmodels.classes.implextend");
        Mockito.lenient().when((Object)this.bundle.getHeaders()).thenReturn(headers);
        Vector<URL> classUrls = new Vector<URL>();
        classUrls.add(this.getClassUrl(ExtendsClassPropertyModel.class));
        classUrls.add(this.getClassUrl(ImplementsInterfacePropertyModel.class));
        classUrls.add(this.getClassUrl(ImplementsInterfacePropertyModel2.class));
        classUrls.add(this.getClassUrl(InvalidImplementsInterfacePropertyModel.class));
        classUrls.add(this.getClassUrl(InvalidSampleServiceInterface.class));
        classUrls.add(this.getClassUrl(SampleServiceInterface.class));
        classUrls.add(this.getClassUrl(SimplePropertyModel.class));
        Mockito.lenient().when((Object)this.bundle.findEntries(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn(classUrls.elements());
        Mockito.lenient().when((Object)this.bundle.loadClass(ArgumentMatchers.anyString())).then(new Answer<Class<?>>(){

            public Class<?> answer(InvocationOnMock invocation) throws ClassNotFoundException {
                String className = (String)invocation.getArguments()[0];
                return ImplementsExtendsTest.this.getClass().getClassLoader().loadClass(className);
            }
        });
        this.registeredAdapterFactories = this.factory.listener.addingBundle(this.bundle, this.bundleEvent);
    }

    private URL getClassUrl(Class<?> clazz) throws MalformedURLException {
        String path = "file:/" + clazz.getName().replace('.', '/') + ".class";
        return new URL(path);
    }

    @AfterEach
    void tearDown() {
        this.factory.listener.removedBundle(this.bundle, this.bundleEvent, this.registeredAdapterFactories);
        Resource res = this.getMockResourceWithProps();
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getAdapter((Object)res, SampleServiceInterface.class), (String)"Getting the model for interface 'SampleServiceInterface' should fail after the accroding adapter factory has been unregistered");
    }

    @Test
    void testImplementsInterfaceModel() {
        Resource res = this.getMockResourceWithProps();
        SampleServiceInterface model = (SampleServiceInterface)this.factory.getAdapter((Object)res, SampleServiceInterface.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(ImplementsInterfacePropertyModel.class, model.getClass());
        Assertions.assertEquals((Object)"first-value|null|third-value", (Object)model.getAllProperties());
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)res, SampleServiceInterface.class));
    }

    @Test
    void testImplementsNoPickerWithAdapterEqualsImplementation() {
        this.factory.implementationPickers = Collections.emptyList();
        Resource res = this.getMockResourceWithProps();
        SampleServiceInterface model = (SampleServiceInterface)this.factory.getAdapter((Object)res, ImplementsInterfacePropertyModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"first-value|null|third-value", (Object)model.getAllProperties());
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)res, ImplementsInterfacePropertyModel.class));
    }

    @Test
    void testImplementsNoPickerWithDifferentImplementations() {
        this.factory.implementationPickers = Collections.emptyList();
        Resource res = this.getMockResourceWithProps();
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getAdapter((Object)res, SampleServiceInterface.class));
    }

    @Test
    void testInvalidImplementsInterfaceModel() {
        Resource res = this.getMockResourceWithProps();
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.getAdapter((Object)res, InvalidSampleServiceInterface.class));
    }

    @Test
    void testExtendsClassModel() {
        Resource res = this.getMockResourceWithProps();
        SimplePropertyModel model = (SimplePropertyModel)this.factory.getAdapter((Object)res, SimplePropertyModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"!first-value|null|third-value!", (Object)model.getAllProperties());
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)res, SimplePropertyModel.class));
        EvenSimplerPropertyModel simplerModel = (EvenSimplerPropertyModel)this.factory.getAdapter((Object)res, EvenSimplerPropertyModel.class);
        Assertions.assertNotNull((Object)simplerModel);
        Assertions.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)res, EvenSimplerPropertyModel.class));
    }

    @Test
    void testImplementsInterfaceModelWithPickLastImplementationPicker() {
        this.factory.implementationPickers = Arrays.asList(new AdapterImplementationsTest.LastImplementationPicker(), this.firstImplementationPicker);
        Resource res = this.getMockResourceWithProps();
        SampleServiceInterface model = (SampleServiceInterface)this.factory.getAdapter((Object)res, SampleServiceInterface.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(ImplementsInterfacePropertyModel2.class, model.getClass());
        Assertions.assertEquals((Object)"first-value|null|third-value", (Object)model.getAllProperties());
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)res, SampleServiceInterface.class));
    }

    private Resource getMockResourceWithProps() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        return res;
    }
}

