/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

abstract class OnewayLinearTransform
extends AbstractMathTransform.Inverse
implements Serializable {
    private static final long serialVersionUID = -3677320306734738831L;
    protected final LinearTransform delegate;

    protected OnewayLinearTransform(LinearTransform delegate) {
        this.delegate = delegate;
    }

    static boolean isNullOrDelegate(MathTransform tr, MathTransform wrapper) {
        return tr == null || wrapper instanceof OnewayLinearTransform && ((OnewayLinearTransform)wrapper).delegate == tr;
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        return this.delegate.derivative(point);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (this.delegate instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)((Object)this.delegate)).transform(srcPts, srcOff, dstPts, dstOff, derivate);
        }
        if (dstPts != null) {
            this.delegate.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivate ? this.delegate.derivative(null) : null;
    }

    @Override
    public DirectPosition transform(DirectPosition source, DirectPosition target) throws TransformException {
        return this.delegate.transform(source, target);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    static final class Concatenated
    extends OnewayLinearTransform {
        private static final long serialVersionUID = -4439900049126605063L;
        private final AbstractMathTransform kernel;
        private final MathTransform inverse;

        Concatenated(LinearTransform delegate, AbstractMathTransform kernel, MathTransform inverse) {
            super(delegate);
            this.kernel = kernel;
            this.inverse = inverse;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            ParameterValueGroup parameters = this.getParameterValues();
            return parameters != null ? parameters.getDescriptor() : null;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return this.kernel != null ? this.kernel.getContextualParameters() : null;
        }

        @Override
        public MathTransform inverse() {
            return this.inverse;
        }
    }
}

