/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.NumberType;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridAdjustment;
import org.apache.sis.storage.netcdf.base.GridMapping;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.referencing.operation.Matrix;

public abstract class Variable
extends Node {
    private static final WeakHashSet<Vector> SHARED_VECTORS = new WeakHashSet(Vector.class);
    public static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(.+)\\Wsince\\W(.+)", 2);
    protected static final int STRING_DIMENSION = 2;
    private VariableRole role;
    private Unit<?> unit;
    protected Instant epoch;
    private boolean unitParsed;
    private Map<Number, Object> nodataValues;
    private Map<Long, String> enumeration;
    private GridGeometry gridGeometry;
    private boolean gridDetermined;
    int bandDimension;
    private transient Vector values;
    private transient List<?> valuesAnyType;

    protected Variable(Decoder decoder) {
        super(decoder);
    }

    protected final void setEnumeration(Map<Long, String> enumeration) {
        if (enumeration == null) {
            String srcLabels = "flag_names";
            CharSequence[] labels = this.getAttributeAsStrings("flag_names", ' ');
            if (labels == null) {
                srcLabels = "flag_meanings";
                labels = this.getAttributeAsStrings("flag_meanings", ' ');
                if (labels == null) {
                    return;
                }
            }
            String srcNumbers = "flag_values";
            Vector numbers = this.getAttributeAsVector("flag_values");
            if (numbers == null) {
                srcNumbers = "flag_masks";
                numbers = this.getAttributeAsVector("flag_masks");
            }
            int count = labels.length;
            if (numbers != null) {
                int n2 = numbers.size();
                if (n2 != count) {
                    this.warning(Variable.class, "setEnumeration", null, (short)24, this.getName(), srcNumbers, srcLabels, n2, count);
                    if (n2 < count) {
                        count = n2;
                    }
                }
            } else {
                numbers = Vector.createSequence((Number)0, (Number)1, (int)count);
                this.warning(Variable.class, "setEnumeration", null, (short)23, this.getFilename(), this.getName(), "flag_values");
            }
            RuntimeException error = null;
            StringBuilder invalids = null;
            enumeration = JDK19.newHashMap((int)count);
            for (int i = 0; i < count; ++i) {
                try {
                    CharSequence label = labels[i];
                    if (label == null) continue;
                    long value = numbers.longValue(i);
                    enumeration.merge(value, label.toString(), (o, n) -> o.equals(n) ? o : o + " | " + n);
                    continue;
                }
                catch (ArithmeticException | NumberFormatException e) {
                    if (error == null) {
                        error = e;
                        invalids = new StringBuilder();
                    } else {
                        boolean tooManyErrors;
                        error.addSuppressed(e);
                        int length = invalids.length();
                        boolean bl = tooManyErrors = length > 100;
                        if (tooManyErrors && invalids.charAt(length - 1) == '\u2026') continue;
                        invalids.append(", ");
                        if (tooManyErrors) {
                            invalids.append('\u2026');
                            continue;
                        }
                    }
                    invalids.append(numbers.stringValue(i));
                }
            }
            if (invalids != null) {
                this.warning(Variable.class, "setEnumeration", error, (short)28, this.getName(), numbers.getElementType(), invalids);
            }
        }
        if (!enumeration.isEmpty()) {
            this.enumeration = enumeration;
        }
    }

    public String getFilename() {
        return this.decoder.getFilename();
    }

    @Override
    public abstract String getName();

    public final String getStandardName() {
        String name = this.getAttributeAsString("standard_name");
        return name != null ? name : this.getName();
    }

    public abstract String getDescription();

    protected abstract String getUnitsString();

    protected abstract Unit<?> parseUnit(String var1) throws Exception;

    final void setUnit(Unit<?> unit, Instant epoch) {
        this.unit = unit;
        this.epoch = epoch;
        this.unitParsed = true;
    }

    public final Unit<?> getUnit() {
        if (!this.unitParsed) {
            Throwable error;
            String symbols;
            block10: {
                this.unitParsed = true;
                symbols = this.getUnitsString();
                error = null;
                if (symbols != null) {
                    try {
                        this.unit = this.parseUnit(symbols);
                    }
                    catch (Exception ex) {
                        error = ex;
                    }
                }
                if (this.unit == null) {
                    try {
                        this.unit = this.decoder.convention().getUnitFallback(this);
                    }
                    catch (MeasurementParseException ex) {
                        if (error == null) {
                            error = ex;
                        } else {
                            error.addSuppressed(ex);
                        }
                        if (symbols != null) break block10;
                        symbols = ex.getParsedString();
                    }
                }
            }
            if (error != null) {
                this.error(Variable.class, "getUnit", (Exception)error, (short)7, this.getName(), symbols);
            }
        }
        return this.unit;
    }

    final boolean hasRealValues() {
        NumberType n = this.getDataType().number;
        if (n == NumberType.FLOAT | n == NumberType.DOUBLE) {
            Convention convention = this.decoder.convention();
            if (convention != Convention.DEFAULT) {
                return convention.transferFunction(this).isIdentity();
            }
            Number c = this.getAttributeAsNumber("scale_factor");
            if (c == null || c.doubleValue() == 1.0) {
                c = this.getAttributeAsNumber("add_offset");
                return c == null || c.doubleValue() == 0.0;
            }
        }
        return false;
    }

    public abstract DataType getDataType();

    public final VariableRole getRole() {
        if (this.role == null) {
            String name = this.getName();
            for (Variable variable : this.decoder.getVariables()) {
                if (!name.equalsIgnoreCase(variable.getAttributeAsString("bounds"))) continue;
                this.role = VariableRole.BOUNDS;
                return this.role;
            }
            this.role = this.decoder.convention().roleOf(this);
        }
        return this.role;
    }

    final boolean isString() {
        return this.getNumDimensions() >= 2 && this.getDataType() == DataType.CHAR;
    }

    protected abstract boolean isUnlimited();

    protected abstract boolean isCoordinateSystemAxis();

    protected abstract String getAxisType();

    protected Grid findGrid(GridAdjustment adjustment) throws IOException, DataStoreException {
        int i;
        Convention convention = this.decoder.convention();
        ArrayList<Variable> axes = new ArrayList<Variable>();
        HashMap<Object, Dimension> domain = new HashMap<Object, Dimension>();
        for (Variable candidate : this.decoder.getVariables()) {
            if (candidate.getRole() != VariableRole.AXIS) continue;
            axes.add(candidate);
            for (Dimension dim : candidate.getGridDimensions()) {
                domain.put(dim, dim);
            }
        }
        boolean isIncomplete = false;
        List<Dimension> fromVariable = this.getGridDimensions();
        Dimension[] dimensions = (Dimension[])fromVariable.toArray(Dimension[]::new);
        for (i = 0; i < dimensions.length; ++i) {
            dimensions[i] = (Dimension)domain.remove(dimensions[i]);
            isIncomplete |= dimensions[i] == null;
        }
        if (isIncomplete) {
            for (i = 0; i < dimensions.length; ++i) {
                Dimension gridDimension;
                if (dimensions[i] != null) continue;
                String label = convention.nameOfDimension(this, i);
                if (label == null) {
                    return null;
                }
                if (isIncomplete) {
                    isIncomplete = false;
                    if (adjustment.mapLabelToGridDimensions(this, axes, domain, convention)) {
                        return null;
                    }
                }
                Dimension varDimension = fromVariable.get(i);
                dimensions[i] = gridDimension = domain.remove(label);
                if (gridDimension == null) {
                    this.warning(Variable.class, "getGridGeometry", null, (short)15, this.getFilename(), this.getName(), label);
                    return null;
                }
                if (adjustment.gridToVariable.put(gridDimension, varDimension) == null) continue;
                throw new InternalDataStoreException(this.errors().getString((short)42, (Object)gridDimension));
            }
        }
        Grid fallback = null;
        boolean fallbackMatches = false;
        String[] axisNames = convention.namesOfAxisVariables(this);
        for (Grid candidate : this.decoder.getGridCandidates()) {
            Grid grid = candidate.forDimensions(dimensions);
            if (grid == null) continue;
            int gridDimension = grid.getSourceDimensions();
            boolean gridMatches = grid.containsAllNamedAxes(axisNames);
            if (gridMatches && gridDimension == dimensions.length) {
                return grid;
            }
            if (!(gridMatches | !fallbackMatches) || gridMatches == fallbackMatches && fallback != null && gridDimension <= fallback.getSourceDimensions()) continue;
            fallbackMatches = gridMatches;
            fallback = grid;
        }
        return fallback;
    }

    public final GridGeometry getGridGeometry() throws IOException, DataStoreException {
        if (!this.gridDetermined) {
            this.gridDetermined = true;
            GridMapping gridMapping = GridMapping.forVariable(this);
            GridAdjustment adjustment = new GridAdjustment();
            Grid info = this.findGrid(adjustment);
            if (info != null) {
                GridGeometry grid;
                List<Dimension> dimensions = this.getGridDimensions();
                int dataDimension = dimensions.size();
                if (dataDimension > info.getSourceDimensions()) {
                    boolean copied = false;
                    List<Dimension> toKeep = info.getDimensions();
                    int numToKeep = toKeep.size();
                    for (int i = 0; i < numToKeep; ++i) {
                        Dimension expected = toKeep.get(i);
                        expected = adjustment.gridToVariable.getOrDefault(expected, expected);
                        while (!expected.equals(dimensions.get(i))) {
                            if (!copied) {
                                copied = true;
                                dimensions = new ArrayList<Dimension>(dimensions);
                            }
                            this.bandDimension = dataDimension - 1 - i;
                            dimensions.remove(i);
                            int j = dimensions.size();
                            while (--j >= i) {
                                dimensions.set(j, dimensions.get(j).decrementIndex());
                            }
                            if (dimensions.size() >= numToKeep) continue;
                            throw new InternalDataStoreException();
                        }
                    }
                }
                if ((grid = info.getGridGeometry(this.decoder)) != null) {
                    if (grid.isDefined(4)) {
                        GridExtent extent = grid.getExtent();
                        long[] sizes = new long[extent.getDimension()];
                        boolean needsResize = false;
                        int i = sizes.length;
                        while (--i >= 0) {
                            int d = sizes.length - 1 - i;
                            sizes[i] = dimensions.get(d).length();
                            if (needsResize) continue;
                            needsResize = sizes[i] != extent.getSize(i);
                        }
                        if (needsResize) {
                            double[] dataToGridIndices = adjustment.dataToGridIndices();
                            if (dataToGridIndices == null || dataToGridIndices.length < sizes.length) {
                                this.warning(Variable.class, "getGridGeometry", null, (short)17, this.getFilename(), this.getName());
                                return null;
                            }
                            extent = extent.resize(sizes);
                            grid = GridAdjustment.scale(grid, extent, info.getAnchor(), dataToGridIndices);
                        }
                    }
                    if (gridMapping != null) {
                        grid = gridMapping.adaptGridCRS(this, grid, info.getAnchor());
                    }
                }
                this.gridGeometry = grid;
            } else if (gridMapping != null) {
                this.gridGeometry = gridMapping.createGridCRS(this);
            }
        }
        return this.gridGeometry;
    }

    final long getBandStride() throws IOException, DataStoreException {
        long length = 1L;
        GridExtent extent = this.getGridGeometry().getExtent();
        int i = this.bandDimension;
        while (--i >= 0) {
            length = Math.multiplyExact(length, extent.getSize(i));
        }
        return length;
    }

    public abstract int getNumDimensions();

    public abstract List<Dimension> getGridDimensions();

    final NumberRange<?> getValidRange() {
        NumberRange<?> range = this.decoder.convention().validRange(this);
        if (range == null) {
            range = this.getRangeFallback();
        }
        return range;
    }

    protected NumberRange<?> getRangeFallback() {
        int size;
        DataType dataType = this.getDataType();
        if (dataType.isInteger && (size = dataType.size() * 8) > 0 && size <= 64) {
            long min = 0L;
            long max = Numerics.bitmask((int)size) - 1L;
            if (!dataType.isUnsigned) {
                min = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (Number value : this.getNodataValues().keySet()) {
                long n = value.longValue();
                long \u0394min = n - min;
                long \u0394max = max - n;
                if (\u0394min < 0L || \u0394max < 0L) continue;
                if (\u0394min < \u0394max) {
                    min = n + 1L;
                    continue;
                }
                max = n - 1L;
            }
            if (max > min) {
                if (min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
                    return NumberRange.create((int)((int)min), (boolean)true, (int)((int)max), (boolean)true);
                }
                return NumberRange.create((long)min, (boolean)true, (long)max, (boolean)true);
            }
        }
        return null;
    }

    final Map<Long, String> getEnumeration() {
        return this.enumeration;
    }

    final Map<Number, Object> getNodataValues() {
        if (this.nodataValues == null) {
            this.nodataValues = Containers.unmodifiable(this.decoder.convention().nodataValues(this));
        }
        return this.nodataValues;
    }

    final TransferFunction getTransferFunction() {
        return this.decoder.convention().transferFunction(this);
    }

    protected boolean isExternallyCached() {
        return false;
    }

    public final Vector read() throws IOException, DataStoreException {
        if (this.values == null) {
            this.setValues(this.readFully(), false);
        }
        return this.values;
    }

    public final List<?> readAnyType() throws IOException, DataStoreException {
        if (this.valuesAnyType == null) {
            this.setValues(this.readFully(), false);
        }
        return this.valuesAnyType;
    }

    public abstract Vector read(GridExtent var1, long[] var2) throws IOException, DataStoreException;

    public abstract List<?> readAnyType(GridExtent var1, long[] var2) throws IOException, DataStoreException;

    protected abstract Object readFully() throws IOException, DataStoreException;

    final void setValues(Object array, boolean forceNumerics) {
        int n;
        DataType dataType = this.getDataType();
        if (dataType == DataType.CHAR && (n = this.getNumDimensions()) >= 2) {
            List<Dimension> dimensions = this.getGridDimensions();
            int length = Math.toIntExact(dimensions.get(--n).length());
            long count = dimensions.get(--n).length();
            while (n > 0) {
                count = Math.multiplyExact(count, dimensions.get(--n).length());
            }
            if (forceNumerics) {
                assert ((long)Array.getLength(array) == count) : this.getName();
                this.valuesAnyType = this.values = (Vector)SHARED_VECTORS.unique((Object)Vector.create((Object)array, (boolean)false));
                return;
            }
            assert ((long)Array.getLength(array) == count * (long)length) : this.getName();
            Object[] strings = this.createStringArray(array, Math.toIntExact(count), length);
            this.values = Vector.create((Object)strings, (boolean)false);
            this.valuesAnyType = Containers.viewAsUnmodifiableList((Object[])strings);
            return;
        }
        Vector data = Variable.createDecimalVector(array, dataType.isUnsigned);
        if (!this.isExternallyCached()) {
            int n2;
            double tolerance = 0.0;
            if (NumberType.isFractional((Class)data.getElementType()) && (n2 = data.size() - 1) >= 0) {
                double first = data.doubleValue(0);
                double last = data.doubleValue(n2);
                double inc = Math.abs((last - first) / (double)n2);
                if (!Double.isNaN(inc)) {
                    double ulp = Math.ulp(Math.max(Math.abs(first), Math.abs(last)));
                    tolerance = Math.min(inc, ulp);
                }
            }
            data = data.compress(tolerance);
        }
        this.valuesAnyType = this.values = (Vector)SHARED_VECTORS.unique((Object)data);
    }

    protected abstract String[] createStringArray(Object var1, int var2, int var3);

    protected final List<String> createStringList(Object chars, GridExtent area) {
        int length = Math.toIntExact(area.getSize(0));
        long count = area.getSize(1);
        int i = area.getDimension();
        while (--i >= 2) {
            count = Math.multiplyExact(count, area.getSize(i));
        }
        return Containers.viewAsUnmodifiableList((Object[])this.createStringArray(chars, Math.toIntExact(count), length));
    }

    protected static Vector createDecimalVector(Object data, boolean isUnsigned) {
        if (data instanceof float[]) {
            return Vector.createForDecimal((float[])((float[])data));
        }
        return Vector.create((Object)data, (boolean)isUnsigned);
    }

    protected final void replaceNaN(Object array) {
        if (this.hasRealValues()) {
            int ordinal = 0;
            for (Number value : this.getNodataValues().keySet()) {
                float pad = MathFunctions.toNanFloat((int)ordinal++);
                if (array instanceof float[]) {
                    ArraysExt.replace((float[])((float[])array), (float)value.floatValue(), (float)pad);
                    continue;
                }
                if (!(array instanceof double[])) continue;
                ArraysExt.replace((double[])((double[])array), (double)value.doubleValue(), (double)pad);
            }
        }
    }

    protected abstract double coordinateForAxis(int var1, int var2) throws IOException, DataStoreException;

    protected boolean trySetTransform(Matrix gridToCRS, int srcDim, int tgtDim, Vector data) throws IOException, DataStoreException {
        int n = data.size() - 1;
        if (n >= 0) {
            Number increment;
            double first = data.doubleValue(0);
            if (n >= 1) {
                double last = data.doubleValue(n);
                double error = this.getDataType() == DataType.FLOAT ? (double)Math.max(Math.ulp((float)first), Math.ulp((float)last)) : Math.max(Math.ulp(first), Math.ulp(last));
                error = Math.max(Math.ulp(last - first), error) / (double)n;
                increment = data.increment(error);
            } else {
                increment = Double.NaN;
            }
            if (increment != null) {
                gridToCRS.setElement(tgtDim, srcDim, ((Number)increment).doubleValue());
                gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, first);
                return true;
            }
        }
        return false;
    }

    protected final DataStoreContentException canNotComputePosition(ArithmeticException cause) {
        return new DataStoreContentException(this.decoder.resources().getString((short)6, this.getFilename(), this.getName()), (Throwable)cause);
    }

    public final void writeDataTypeName(StringBuilder buffer) {
        buffer.append(this.getDataType().name().toLowerCase(Decoder.DATA_LOCALE));
        List<Dimension> dimensions = this.getGridDimensions();
        int i = dimensions.size();
        while (--i >= 0) {
            dimensions.get(i).writeLength(buffer);
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName()).append(" : ");
        this.writeDataTypeName(buffer);
        if (this.isUnlimited()) {
            buffer.append(" (unlimited)");
        }
        return buffer.toString();
    }
}

