# Maturity Assessment for Apache ShenYu

The [Apache Project Maturity Model](https://community.apache.org/apache-way/apache-project-maturity-model.html) provides a suggested framework for evaluating the overall maturity of an Apache project community and the codebase that it maintains.

All the items of the mode are updated to the latest status of the project in the following table.

**CODE**

| **ID**   | **Description**                                                                                                                                                                                                                                                | **Status** |
|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **CD10** | The project produces Open Source software for distribution to the public, at no charge.                                                                                                                                                                        | **YES.**   |
| **CD20** | Anyone can easily discover and access the project's code.                                                                                                                                                                                                      | **YES.**   |
| **CD30** | Anyone using standard, widely-available tools, can build the code in a reproducible way.                                                                                                                                                                       | **YES.**   |
| **CD40** | The full history of the project's code is available via a source code control system, in a way that allows anyone to recreate any released version.                                                                                                            | **YES.**   |
| **CD50** | The source code control system establishes the provenance of each line of code in a reliable way, based on strong authentication of the committer. When third parties contribute code, commit messages provide reliable information about the code provenance. | **YES.**   |

**Licenses and Copyright**

| **ID**   | **Description**                                                                                                                                                                   | **Status** |
|----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **LC10** | The Apache License, version 2.0, covers the released code.                                                                                                                        | **YES.**   |
| **LC20** | Libraries that are mandatory dependencies of the project's code do not create more restrictions than the Apache License does.                                                     | **YES.**   |
| **LC30** | The libraries mentioned in LC20 are available as Open Source software.                                                                                                            | **YES.**   |
| **LC40** | Committers are bound by an Individual Contributor Agreement (the "Apache iCLA") that defines which code they may commit and how they need to identify code that is not their own. | **YES.**   |
| **LC50** | The project clearly defines and documents the copyright ownership of everything that the project produces.                                                                        | **YES.**   |

**Releases**

| **ID**   | **Description**                                                                                                                                                        | **Status** |
|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **RE10** | Releases consist of source code, distributed using standard and open archive formats that are expected to stay readable in the long term.                              | **YES.**   |
| **RE20** | The project's PMC (Project Management Committee, see CS10) approves each software release in order to make the release an act of the Foundation.                       | **YES.**   |
| **RE30** | Releases are signed and/or distributed along with digests that anyone can reliably use to validate the downloaded archives.                                            | **YES.**   |
| **RE40** | The project can distribute convenience binaries alongside source code, but they are not Apache Releases, they are provided with no guarantee.                          | **YES.**   |
| **RE50** | The project documents a repeatable release process so that someone new to the project can independently generate the complete set of artifacts required for a release. | **YES.**   |

**Quality**

| **ID**   | **Description**                                                                                                                                                                               | **Status** |
|----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **QU10** | The project is open and honest about the quality of its code. Various levels of quality and maturity for various modules are natural and acceptable as long as they are clearly communicated. | **YES.**   |
| **QU20** | The project puts a very high priority on producing secure software.                                                                                                                           | **YES.**   |
| **QU30** | The project provides a well-documented, secure and private channel to report security issues, along with a documented way of responding to them.                                              | **YES.**   |
| **QU40** | The project puts a high priority on backwards compatibility and aims to document any incompatible changes and provide tools and documentation to help users transition to new features.       | **YES.**   |
| **QU50** | The project strives to respond to documented bug reports in a timely manner.                                                                                                                  | **YES.**   |

**Community**

| **ID**   | **Description**                                                                                                                                                        | **Status** |
|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **CO10** | The project has a well-known homepage that points to all the information required to operate according to this maturity model.                                         | **YES.**   |
| **CO20** | The community welcomes contributions from anyone who acts in good faith and in a respectful manner, and who adds value to the project.                                 | **YES.**   |
| **CO30** | Contributions include source code, documentation, constructive bug reports, constructive discussions, marketing and generally anything that adds value to the project. | **YES.**   |
| **CO40** | The community strives to be meritocratic and gives more rights and responsibilities to contributors who, over time, add value to the project.                          | **YES.**   |
| **CO50** | The project documents how contributors can earn more rights such as commit access or decision power, and applies these principles consistently.                        | **YES.**   |
| **CO60** | The community operates based on consensus of its members (see CS10) who have decision power. Dictators, benevolent or not, are not welcome in Apache projects.         | **YES.**   |
| **CO70** | The project strives to answer user questions in a timely manner.                                                                                                       | **YES.**   |

**Consensus**

| **ID**   | **Description**                                                                                                                                                                                                           | **Status** |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| **CS10** | The project maintains a public list of its contributors who have decision power. The project's PMC (Project Management Committee) consists of those contributors.                                                         | **YES.**   |
| **CS20** | Decisions require a consensus among PMC members and are documented on the project's main communications channel. The PMC takes community opinions into account, but the PMC has the final word.                           | **YES.**   |
| **CS30** | The project uses documented voting rules to build consensus when discussion is not sufficient.                                                                                                                            | **YES.**   |
| **CS40** | In Apache projects, vetoes are only valid for code commits. The person exercising the veto must justify it with a technical explanation, as per the Apache voting rules defined in CS30.                                  | **YES.**   |
| **CS50** | All "important" discussions happen asynchronously in written form on the project's main communications channel. Offline, face-to-face or private discussions that affect the project are also documented on that channel. | **YES.**   |

**Independence**

| **ID**   | **Description**                                                                          | **Status** |
|----------|------------------------------------------------------------------------------------------|------------|
| **IN10** | The project is independent from any corporate or organizational influence.               | **YES.**   |
| **IN20** | Contributors act as themselves, not as representatives of a corporation or organization. | **YES.**   |
