/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParam {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParam.class);
    private Map<String, String[]> queryParams;
    private Map<String, Object> formFields;
    private byte[] body = null;
    private Map<String, String> headers;
    private Map<String, String> cookies;
    private long timeout;

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public RequestParam setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public RequestParam setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public RequestParam setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public Map<String, Object> getFormFields() {
        return this.formFields;
    }

    public RequestParam setFormFields(Map<String, Object> formFields) {
        this.formFields = formFields;
        return this;
    }

    public Map<String, String[]> getQueryParamsMap() {
        return this.queryParams;
    }

    public String getQueryParams() {
        if (this.queryParams == null || this.queryParams.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> query : this.queryParams.entrySet()) {
                for (String val : query.getValue()) {
                    stringBuilder.append("&").append(URLEncoder.encode(query.getKey(), "UTF-8"));
                    if (val == null || val.isEmpty()) continue;
                    stringBuilder.append("=").append(URLEncoder.encode(val, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("get query params failed.", (Throwable)e);
            return "";
        }
        return stringBuilder.substring(1);
    }

    public RequestParam setQueryParams(Map<String, String[]> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public RequestParam addQueryParam(String key, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String[]>();
        }
        if (!this.queryParams.containsKey(key)) {
            this.queryParams.put(key, new String[]{value});
        } else {
            this.queryParams.put(key, (String[])Arrays.asList((Serializable)this.queryParams.get(key), value).toArray());
        }
        return this;
    }

    public RequestParam addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestParam setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

