/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.github.fge.jsonpatch.diff.IndexedJsonArray;
import com.google.common.base.Objects;

final class Diff {
    DiffOperation operation;
    JsonPointer path;
    JsonPointer arrayPath;
    int firstArrayIndex;
    int secondArrayIndex;
    final JsonNode value;
    JsonPointer fromPath;
    Diff pairedDiff;
    boolean firstOfPair;

    static Diff simpleDiff(DiffOperation operation, JsonPointer path, JsonNode value) {
        return new Diff(operation, path, value.deepCopy());
    }

    static Diff tailArrayRemove(JsonPointer basePath, int index, JsonNode victim) {
        return new Diff(DiffOperation.REMOVE, basePath, index, index, victim.deepCopy());
    }

    static Diff arrayRemove(JsonPointer basePath, IndexedJsonArray array1, IndexedJsonArray array2) {
        return new Diff(DiffOperation.REMOVE, basePath, array1.getIndex(), array2.getIndex(), array1.getElement().deepCopy());
    }

    static Diff arrayAdd(JsonPointer basePath, JsonNode node) {
        return new Diff(DiffOperation.ADD, basePath, -1, -1, node.deepCopy());
    }

    static Diff arrayInsert(JsonPointer basePath, IndexedJsonArray array1, IndexedJsonArray array2) {
        return new Diff(DiffOperation.ADD, basePath, array1.getIndex(), array2.getIndex(), array2.getElement().deepCopy());
    }

    private Diff(DiffOperation operation, JsonPointer path, JsonNode value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
    }

    private Diff(DiffOperation operation, JsonPointer arrayPath, int firstArrayIndex, int secondArrayIndex, JsonNode value) {
        this.operation = operation;
        this.arrayPath = arrayPath;
        this.firstArrayIndex = firstArrayIndex;
        this.secondArrayIndex = secondArrayIndex;
        this.value = value;
    }

    JsonNode asJsonPatch() {
        JsonPointer ptr = this.arrayPath != null ? this.getSecondArrayPath() : this.path;
        ObjectNode patch = this.operation.newOp(ptr);
        if (this.operation == DiffOperation.REMOVE) {
            return patch;
        }
        if (this.operation == DiffOperation.MOVE || this.operation == DiffOperation.COPY) {
            patch.put("from", this.fromPath.toString());
        } else {
            patch.put("value", this.value);
        }
        return patch;
    }

    JsonPointer getSecondArrayPath() {
        if (this.secondArrayIndex != -1) {
            return this.arrayPath.append(this.secondArrayIndex);
        }
        return this.arrayPath.append("-");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operation, this.path, this.arrayPath, this.firstArrayIndex, this.secondArrayIndex, JsonNumEquals.getInstance().wrap((Object)this.value), this.fromPath, this.pairedDiff != null, this.firstOfPair});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Diff other = (Diff)obj;
        return this.operation == other.operation && Objects.equal((Object)this.path, (Object)other.path) && Objects.equal((Object)this.arrayPath, (Object)other.arrayPath) && this.firstArrayIndex == other.firstArrayIndex && this.secondArrayIndex == other.secondArrayIndex && JsonNumEquals.getInstance().equivalent((Object)this.value, (Object)other.value) && Objects.equal((Object)this.fromPath, (Object)other.fromPath) && Objects.equal((Object)(this.pairedDiff != null ? 1 : 0), (Object)(other.pairedDiff != null ? 1 : 0)) && this.firstOfPair == other.firstOfPair;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("op", (Object)this.operation).add("path", (Object)this.path).add("arrayPath", (Object)this.arrayPath).add("firstArrayIndex", this.firstArrayIndex).add("secondArrayIndex", this.secondArrayIndex).add("value", (Object)this.value).add("fromPath", (Object)this.fromPath).add("paired", this.pairedDiff != null).add("firstOfPair", this.firstOfPair).toString();
    }
}

