/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.darklaunch;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.darklaunch.DarklaunchRule;
import org.apache.servicecomb.darklaunch.DarklaunchRuleItem;
import org.apache.servicecomb.darklaunch.MicroserviceCache;
import org.apache.servicecomb.darklaunch.PolicyType;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.registry.api.registry.Microservice;

public class DarklaunchServerListFilter
implements ServerListFilterExt {
    private static final String POLICY_CSE = "cse.darklaunch.policy.%s";
    private static final String POLICY_SERVICE_COMB = "servicecomb.darklaunch.policy.%s";
    private static final int HUNDRED = 100;
    private final Random random = new Random();

    public int getOrder() {
        return 100;
    }

    public boolean enabled() {
        return true;
    }

    public List<ServiceCombServer> getFilteredListOfServers(List<ServiceCombServer> serverList, Invocation invocation) {
        DarklaunchRule rule;
        DynamicStringProperty ruleStr = DynamicPropertyFactory.getInstance().getStringProperty(String.format(POLICY_SERVICE_COMB, invocation.getMicroserviceName()), null);
        if (ruleStr == null) {
            ruleStr = DynamicPropertyFactory.getInstance().getStringProperty(String.format(POLICY_CSE, invocation.getMicroserviceName()), null);
        }
        if ((rule = DarklaunchRule.parse(ruleStr.get())) == null) {
            return serverList;
        }
        ArrayList<ServiceCombServer> defaultGroup = new ArrayList<ServiceCombServer>();
        this.divideServerGroup(serverList, rule, defaultGroup);
        if (rule.getPolicyType() == PolicyType.RULE) {
            for (DarklaunchRuleItem item : rule.getRuleItems()) {
                List<ServiceCombServer> ruleServers = this.getRuleServers(invocation, item, defaultGroup);
                if (ruleServers == null) continue;
                return ruleServers;
            }
        } else {
            int rate = this.random.nextInt(100);
            for (DarklaunchRuleItem item : rule.getRuleItems()) {
                item.getPolicyCondition().setActual("rate", rate);
                if (item.getPolicyCondition().match()) {
                    if (item.getServers().isEmpty()) {
                        return defaultGroup;
                    }
                    return item.getServers();
                }
                rate -= Integer.parseInt(item.getPolicyCondition().expected());
            }
        }
        return defaultGroup;
    }

    private List<ServiceCombServer> getRuleServers(Invocation invocation, DarklaunchRuleItem item, List<ServiceCombServer> defaultGroup) {
        invocation.getSwaggerArguments().forEach((k, v) -> item.getPolicyCondition().setActual((String)k, v));
        for (String key : invocation.getContext().keySet()) {
            item.getPolicyCondition().setActual(key, invocation.getContext(key));
        }
        if (item.getPolicyCondition().match()) {
            if (item.getServers().isEmpty()) {
                return defaultGroup;
            }
            return item.getServers();
        }
        return null;
    }

    private void divideServerGroup(List<ServiceCombServer> serverList, DarklaunchRule rule, List<ServiceCombServer> defaultGroup) {
        for (ServiceCombServer server : serverList) {
            boolean hasGroup = false;
            for (DarklaunchRuleItem item : rule.getRuleItems()) {
                Microservice microservice = MicroserviceCache.getInstance().getService(server.getInstance().getServiceId());
                item.getGroupCondition().setActual("version", microservice.getVersion());
                if (!item.getGroupCondition().match()) continue;
                item.addServer(server);
                hasGroup = true;
            }
            if (hasGroup) continue;
            defaultGroup.add(server);
        }
    }
}

