/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;

public class ResponseSizeItem
implements AccessLogItem<RoutingContext> {
    private final String zeroBytes;

    public ResponseSizeItem(String zeroBytesPlaceholder) {
        this.zeroBytes = zeroBytesPlaceholder;
    }

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        HttpServerResponse response = accessLogParam.getContextData().response();
        if (null == response) {
            return this.zeroBytes;
        }
        long bytesWritten = response.bytesWritten();
        return 0L == bytesWritten ? this.zeroBytes : String.valueOf(bytesWritten);
    }

    public String getZeroBytes() {
        return this.zeroBytes;
    }
}

