/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.rx;

import org.springframework.cloud.netflix.rx.SingleDeferredResult;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import rx.Single;
import rx.functions.Func1;

public class SingleReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        return returnValue != null && this.supportsReturnType(returnType);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return Single.class.isAssignableFrom(returnType.getParameterType()) || this.isResponseEntity(returnType);
    }

    private boolean isResponseEntity(MethodParameter returnType) {
        if (ResponseEntity.class.isAssignableFrom(returnType.getParameterType())) {
            Class bodyType = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[]{0}).resolve();
            return bodyType != null && Single.class.isAssignableFrom(bodyType);
        }
        return false;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        ResponseEntity<Single<?>> responseEntity = this.getResponseEntity(returnValue);
        if (responseEntity != null && (returnValue = responseEntity.getBody()) == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        Single single = (Single)Single.class.cast(returnValue);
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(this.convertToDeferredResult(responseEntity, single), new Object[]{mavContainer});
    }

    private ResponseEntity<Single<?>> getResponseEntity(Object returnValue) {
        if (ResponseEntity.class.isAssignableFrom(returnValue.getClass())) {
            return (ResponseEntity)returnValue;
        }
        return null;
    }

    protected DeferredResult<?> convertToDeferredResult(final ResponseEntity<Single<?>> responseEntity, Single<?> single) {
        Single singleResponse = single.map(new Func1<Object, ResponseEntity<?>>(){

            public ResponseEntity<?> call(Object object) {
                if (object instanceof ResponseEntity) {
                    return (ResponseEntity)object;
                }
                return new ResponseEntity(object, (MultiValueMap)SingleReturnValueHandler.this.getHttpHeaders(responseEntity), SingleReturnValueHandler.this.getHttpStatus(responseEntity));
            }
        });
        return new SingleDeferredResult(singleResponse);
    }

    private HttpStatus getHttpStatus(ResponseEntity<?> responseEntity) {
        if (responseEntity == null) {
            return HttpStatus.OK;
        }
        return responseEntity.getStatusCode();
    }

    private HttpHeaders getHttpHeaders(ResponseEntity<?> responseEntity) {
        if (responseEntity == null) {
            return new HttpHeaders();
        }
        return responseEntity.getHeaders();
    }
}

