/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AdaptCachedBodyGlobalFilter
implements GlobalFilter,
Ordered {
    public static final String CACHED_REQUEST_BODY_KEY = "cachedRequestBody";

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        final Flux body = (Flux)exchange.getAttributeOrDefault(CACHED_REQUEST_BODY_KEY, null);
        if (body != null) {
            ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator(exchange.getRequest()){

                public Flux<DataBuffer> getBody() {
                    return body;
                }
            };
            exchange.getAttributes().remove(CACHED_REQUEST_BODY_KEY);
            return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147482648;
    }
}

