/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;

@DataObject
public class DeliveryOptions {
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final boolean DEFAULT_LOCAL_ONLY = false;
    private long timeout = 30000L;
    private String codecName;
    private MultiMap headers;
    private boolean localOnly = false;

    public DeliveryOptions() {
    }

    public DeliveryOptions(DeliveryOptions other) {
        this.timeout = other.getSendTimeout();
        this.codecName = other.getCodecName();
        this.headers = other.getHeaders();
        this.localOnly = other.localOnly;
    }

    public DeliveryOptions(JsonObject json) {
        this.timeout = json.getLong("timeout", 30000L);
        this.codecName = json.getString("codecName", null);
        JsonObject hdrs = json.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
            for (Map.Entry<String, Object> entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + entry.getValue().getClass());
                }
                this.headers.set(entry.getKey(), (String)entry.getValue());
            }
        }
        this.localOnly = json.getBoolean("localOnly", false);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("timeout", this.timeout);
        if (this.codecName != null) {
            json.put("codecName", this.codecName);
        }
        if (this.headers != null) {
            JsonObject hJson = new JsonObject();
            this.headers.entries().forEach(entry -> hJson.put((String)entry.getKey(), (String)entry.getValue()));
            json.put("headers", hJson);
        }
        json.put("localOnly", this.localOnly);
        return json;
    }

    public long getSendTimeout() {
        return this.timeout;
    }

    public DeliveryOptions setSendTimeout(long timeout) {
        Arguments.require(timeout >= 1L, "sendTimeout must be >= 1");
        this.timeout = timeout;
        return this;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public DeliveryOptions setCodecName(String codecName) {
        this.codecName = codecName;
        return this;
    }

    public DeliveryOptions addHeader(String key, String value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public DeliveryOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public DeliveryOptions setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
        return this;
    }
}

