/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.auth;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.AclInfo;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class GetAclSubCommand
implements SubCommand {
    private static final String FORMAT = "%-16s  %-10s  %-22s  %-20s  %-24s  %-10s%n";

    @Override
    public String commandName() {
        return "getAcl";
    }

    @Override
    public String commandDesc() {
        return "Get acl from cluster.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("b", "brokerAddr", true, "get acl for which broker");
        optionGroup.addOption(opt);
        opt = new Option("c", "clusterName", true, "get acl for specified cluster");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        opt = new Option("s", "subject", true, "the subject of acl to get");
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String subject = StringUtils.trim((String)commandLine.getOptionValue('s'));
            if (commandLine.hasOption('b')) {
                String addr = StringUtils.trim((String)commandLine.getOptionValue('b'));
                defaultMQAdminExt.start();
                AclInfo aclInfo = defaultMQAdminExt.getAcl(addr, subject);
                if (aclInfo != null) {
                    this.printAcl(aclInfo);
                }
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = StringUtils.trim((String)commandLine.getOptionValue('c'));
                defaultMQAdminExt.start();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                if (CollectionUtils.isEmpty(masterSet)) {
                    throw new SubCommandException(this.getClass().getSimpleName() + " command failed, there is no broker in cluster.");
                }
                for (String masterAddr : masterSet) {
                    AclInfo aclInfo = defaultMQAdminExt.getAcl(masterAddr, subject);
                    if (aclInfo == null) continue;
                    this.printAcl(aclInfo);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private void printAcl(AclInfo acl) {
        if (acl == null) {
            return;
        }
        System.out.printf(FORMAT, "#Subject", "#PolicyType", "#Resource", "#Actions", "#SourceIp", "#Decision");
        List policyInfos = acl.getPolicies();
        if (CollectionUtils.isEmpty((Collection)policyInfos)) {
            System.out.printf(FORMAT, acl.getSubject(), "", "", "", "", "");
        }
        policyInfos.forEach(policy -> {
            List entries = policy.getEntries();
            if (CollectionUtils.isEmpty((Collection)entries)) {
                return;
            }
            entries.forEach(entry -> System.out.printf(FORMAT, acl.getSubject(), policy.getPolicyType(), entry.getResource(), entry.getActions(), entry.getSourceIps(), entry.getDecision()));
        });
    }
}

