/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.strategy;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.exception.AuthorizationException;
import org.apache.rocketmq.auth.authorization.factory.AuthorizationFactory;
import org.apache.rocketmq.auth.authorization.provider.AuthorizationProvider;
import org.apache.rocketmq.auth.authorization.strategy.AuthorizationStrategy;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.utils.ExceptionUtils;

public abstract class AbstractAuthorizationStrategy
implements AuthorizationStrategy {
    protected final AuthConfig authConfig;
    protected final Set<String> authorizationWhiteSet = new HashSet<String>();
    protected final AuthorizationProvider<AuthorizationContext> authorizationProvider;

    public AbstractAuthorizationStrategy(AuthConfig authConfig, Supplier<?> metadataService) {
        this.authConfig = authConfig;
        this.authorizationProvider = AuthorizationFactory.getProvider(authConfig);
        if (this.authorizationProvider != null) {
            this.authorizationProvider.initialize(authConfig, metadataService);
        }
        if (StringUtils.isNotBlank((CharSequence)authConfig.getAuthorizationWhitelist())) {
            String[] whitelist;
            for (String rpcCode : whitelist = StringUtils.split((String)authConfig.getAuthorizationWhitelist(), (String)",")) {
                this.authorizationWhiteSet.add(StringUtils.trim((String)rpcCode));
            }
        }
    }

    public void doEvaluate(AuthorizationContext context) {
        if (context == null) {
            return;
        }
        if (!this.authConfig.isAuthorizationEnabled()) {
            return;
        }
        if (this.authorizationProvider == null) {
            return;
        }
        if (this.authorizationWhiteSet.contains(context.getRpcCode())) {
            return;
        }
        try {
            this.authorizationProvider.authorize(context).join();
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Throwable exception = ExceptionUtils.getRealException((Throwable)ex);
            if (exception instanceof AuthorizationException) {
                throw (AuthorizationException)exception;
            }
            throw new AuthorizationException("Authorization failed. Please verify your access rights and try again.", exception);
        }
    }
}

