/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.stats;

import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class LmqBrokerStatsManager
extends BrokerStatsManager {
    private final BrokerConfig brokerConfig;

    public LmqBrokerStatsManager(BrokerConfig brokerConfig) {
        super(brokerConfig.getBrokerClusterName(), brokerConfig.isEnableDetailStat());
        this.brokerConfig = brokerConfig;
    }

    @Override
    public void incGroupGetNums(String group, String topic, int incValue) {
        super.incGroupGetNums(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), incValue);
    }

    @Override
    public void incGroupGetSize(String group, String topic, int incValue) {
        super.incGroupGetSize(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), incValue);
    }

    @Override
    public void incGroupAckNums(String group, String topic, int incValue) {
        super.incGroupAckNums(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), incValue);
    }

    @Override
    public void incGroupCkNums(String group, String topic, int incValue) {
        super.incGroupCkNums(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), incValue);
    }

    @Override
    public void incGroupGetLatency(String group, String topic, int queueId, int incValue) {
        super.incGroupGetLatency(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), queueId, incValue);
    }

    @Override
    public void incSendBackNums(String group, String topic) {
        super.incSendBackNums(this.getAdjustedGroup(group), this.getAdjustedTopic(topic));
    }

    @Override
    public double tpsGroupGetNums(String group, String topic) {
        return super.tpsGroupGetNums(this.getAdjustedGroup(group), this.getAdjustedTopic(topic));
    }

    @Override
    public void recordDiskFallBehindTime(String group, String topic, int queueId, long fallBehind) {
        super.recordDiskFallBehindTime(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), queueId, fallBehind);
    }

    @Override
    public void recordDiskFallBehindSize(String group, String topic, int queueId, long fallBehind) {
        super.recordDiskFallBehindSize(this.getAdjustedGroup(group), this.getAdjustedTopic(topic), queueId, fallBehind);
    }

    private String getAdjustedGroup(String group) {
        return !this.brokerConfig.isEnableLmqStats() && MixAll.isLmq((String)group) ? "%LMQ%" : group;
    }

    private String getAdjustedTopic(String topic) {
        return !this.brokerConfig.isEnableLmqStats() && MixAll.isLmq((String)topic) ? "%LMQ%" : topic;
    }
}

